/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xmeta.Action;
import org.xmeta.ActionContext;
import org.xmeta.ActionException;
import org.xmeta.Bindings;
import org.xmeta.Thing;
import org.xmeta.World;
import org.xmeta.annotation.ActionAnnotationHelper;
import org.xmeta.util.ThingLoader;
import org.xmeta.util.UtilMap;

public class ActionContainer {
    private static final Logger logger = Logger.getLogger(ActionContainer.class.getName());
    static World world = World.getInstance();
    private final Thing actions;
    private final ActionContext actionContext;
    private List<Thing> actionThings = null;
    private Object object;
    private Map<String, ActionAnnotationHelper> methods;
    private boolean log = false;
    private Map<String, Object> params = new HashMap<String, Object>();

    public ActionContainer(Thing actions, ActionContext actionContext) {
        this.actionContext = actionContext;
        this.actions = actions;
        for (Thing ext : actions.getExtends()) {
            this.append(ext);
        }
        this.log = actions.getBoolean("log");
        if (actions.getBoolean("thingLoader")) {
            this.object = ThingLoader.getObject();
            if (this.log) {
                logger.info("Get object from ThingLoader, object=" + this.object);
            }
        } else {
            this.object = actions.doAction("getObject", actionContext);
            if (this.log) {
                logger.info("Get object from getObject, object=" + this.object);
            }
            if (this.object == null) {
                Class cls = (Class)actions.doAction("getClass", actionContext);
                if (this.log) {
                    logger.info("Get object from getClass, class=" + cls);
                }
                if (cls != null) {
                    try {
                        this.object = cls.getConstructor(new Class[0]).newInstance(new Object[0]);
                        if (this.log) {
                            logger.info("Get object from getClass, object=" + this.object);
                        }
                        if (this.object != null) {
                            ThingLoader.load(this.object, actionContext, new Class[0]);
                        }
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, "New object error, actions=" + actions.getMetadata().getPath(), e);
                    }
                }
            }
        }
        if (this.object != null) {
            this.setObject(this.object);
        }
    }

    public void setParam(String key, Object value) {
        this.params.put(key, value);
    }

    public <T> T getParam(String key) {
        return (T)this.params.get(key);
    }

    public void setObject(Object object) {
        this.object = object;
        this.methods = new HashMap<String, ActionAnnotationHelper>();
        Class<?> cls = object.getClass();
        for (Method method1 : cls.getMethods()) {
            String name = method1.getName();
            try {
                ActionAnnotationHelper helper = ActionAnnotationHelper.parse(cls, method1);
                this.methods.put(name, helper);
            }
            catch (NoSuchMethodException e) {
                throw new ActionException(e);
            }
        }
    }

    public Thing getThing() {
        return this.actions;
    }

    public void append(Thing action) {
        if (this.actionThings == null) {
            this.actionThings = new ArrayList<Thing>();
        }
        this.actionThings.add(action);
    }

    public List<Thing> getAppendActions() {
        return this.actionThings;
    }

    public ActionAnnotationHelper getMethodHelper(String name) {
        if (this.methods == null) {
            return null;
        }
        return this.methods.get(name);
    }

    public <T> T doAction(String name) {
        return this.doAction(name, Collections.EMPTY_MAP);
    }

    public <T> T doAction(String name, ActionContext context) {
        return this.doAction(name, Collections.EMPTY_MAP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T doAction(String name, Map<String, Object> parameters) {
        try {
            ActionAnnotationHelper helper = this.getMethodHelper(name);
            if (helper != null) {
                if (this.log) {
                    logger.info("Do action [" + this.actions.getMetadata().getPath() + ":" + name + "] by method, method=" + helper.getActionMethod());
                }
                Bindings bindings = this.actionContext.push();
                try {
                    bindings.putAll(this.params);
                    if (parameters != null) {
                        bindings.putAll(parameters);
                    }
                    Object object = helper.invoke(this.object, this.actionContext);
                    return (T)object;
                }
                finally {
                    this.actionContext.pop();
                }
            }
            Thing actionThing = this.getActionThing(name);
            if (actionThing == null) {
                logger.info("Can not do action [" + this.actions.getMetadata().getPath() + ":" + name + "], objec method or action not found");
                return null;
            }
            if (this.log) {
                logger.info("Do action [" + this.actions.getMetadata().getPath() + ":" + name + "] by action, action=" + actionThing.getMetadata().getPath());
            }
            Action action = world.getAction(actionThing.getMetadata().getPath());
            HashMap<String, Object> map = new HashMap<String, Object>(this.params);
            if (parameters == null) return action.run(this.actionContext, map);
            map.putAll(parameters);
            return action.run(this.actionContext, map);
        }
        catch (Throwable e) {
            throw new ActionException("Container do action [" + this.actions.getMetadata().getPath() + ":" + name + "] exception, actions=" + this.actions.getMetadata().getPath(), e);
        }
    }

    public <T> T doAction(String name, ActionContext context, Map<String, Object> parameters) {
        return this.doAction(name, parameters);
    }

    public <T> T doAction(String name, ActionContext context, Object ... parameters) {
        return this.doAction(name, context, UtilMap.toMap(parameters));
    }

    public Thing getActionThing(String name) {
        Thing thing = this.getActionThing(this.actions, name);
        if (thing == null && this.actionThings != null) {
            Thing actionThing;
            Iterator<Thing> iterator = this.actionThings.iterator();
            while (iterator.hasNext() && (thing = this.getActionThing(actionThing = iterator.next(), name)) == null) {
            }
        }
        if (thing == null && this.actions.getBoolean("log")) {
            logger.fine("ActionContainer: action is not found : " + this.actions.getMetadata().getPath() + "/@" + name);
            return null;
        }
        return thing;
    }

    private Thing getActionThing(Thing actionThing, String name) {
        for (Thing child : actionThing.getAllChilds()) {
            if (!child.getMetadata().getName().equals(name)) continue;
            return child;
        }
        return actionThing.getActionThing(name);
    }

    public List<Thing> getActionThings() {
        ArrayList<Thing> list = new ArrayList<Thing>();
        HashMap<String, Thing> context = new HashMap<String, Thing>();
        this.initActions(this.actions, list, context);
        if (this.actionThings != null) {
            for (Thing thing : this.actionThings) {
                this.initActions(thing, list, context);
            }
        }
        list.sort((o1, o2) -> o1.getMetadata().getName().compareTo(o2.getMetadata().getName()));
        return list;
    }

    private void initActions(Thing thing, List<Thing> list, Map<String, Thing> context) {
        String name;
        for (Thing child : thing.getAllChilds()) {
            name = child.getMetadata().getName();
            if (context.get(name) != null) continue;
            list.add(child);
            context.put(name, child);
        }
        for (Thing ac : thing.getActionsThings()) {
            name = ac.getMetadata().getName();
            if (context.get(name) != null) continue;
            list.add(ac);
            context.put(name, ac);
        }
    }

    public ActionContext getActionContext() {
        return this.actionContext;
    }

    public String toString() {
        StringBuilder str = new StringBuilder("ActionContainer: path=" + this.actions.getMetadata().getPath() + "\n    actions=");
        for (Thing ac : this.getActionThings()) {
            str.append(ac.getMetadata().getName()).append(",");
        }
        return str.toString();
    }

    public <T> T execute(String name, Object ... parameters) {
        try {
            return this.doAction(name, this.actionContext, parameters);
        }
        catch (Throwable e) {
            throw new ActionException("Container do action [" + name + "] exception, actions=" + this.actions.getMetadata().getPath(), e);
        }
    }
}

