/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.xmeta.ActionContext;
import org.xmeta.Bindings;

public class ActionException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private static final List<Bindings> bindingList = new ArrayList<Bindings>();
    private static String actionContextStack = null;

    public ActionException() {
    }

    public ActionException(String message) {
        super(message);
    }

    public ActionException(String message, Throwable cause) {
        super(message, cause);
    }

    public ActionException(Throwable cause) {
        super(cause);
    }

    public ActionException(String message, ActionContext actionContext) {
        super(message);
        actionContextStack = actionContext.getStackTrace();
        this.initBindings(actionContext);
    }

    public ActionException(String message, Throwable cause, ActionContext actionContext) {
        super(message, cause);
        actionContextStack = actionContext.getStackTrace();
        this.initBindings(actionContext);
    }

    public ActionException(Throwable cause, ActionContext actionContext) {
        super(cause);
        actionContextStack = actionContext.getStackTrace();
        this.initBindings(actionContext);
    }

    protected void initBindings(ActionContext actionContext) {
        for (int i = actionContext.getScopesSize() - 1; i >= 0; --i) {
            Bindings bindings = actionContext.getScope(i);
            bindingList.add(bindings);
        }
    }

    public List<Bindings> getBindings() {
        return bindingList;
    }

    @Override
    public void printStackTrace() {
        Throwable cause;
        if (this.getMessage() != null) {
            System.err.println(this.getMessage());
        }
        if (actionContextStack != null) {
            System.err.print(actionContextStack);
        }
        if ((cause = this.getCause()) != null) {
            cause.printStackTrace();
        } else {
            super.printStackTrace();
        }
    }

    @Override
    public void printStackTrace(PrintStream s) {
        Throwable cause;
        if (this.getMessage() != null) {
            System.err.println(this.getMessage());
        }
        if (actionContextStack != null) {
            s.println(actionContextStack);
        }
        if ((cause = this.getCause()) != null) {
            cause.printStackTrace(s);
        } else {
            super.printStackTrace(s);
        }
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        Throwable cause;
        if (this.getMessage() != null) {
            System.err.println(this.getMessage());
        }
        if (actionContextStack != null) {
            s.println(actionContextStack);
        }
        if ((cause = this.getCause()) != null) {
            cause.printStackTrace(s);
        } else {
            super.printStackTrace(s);
        }
    }

    @Override
    public String getLocalizedMessage() {
        if (super.getLocalizedMessage() == null || "".equals(super.getLocalizedMessage()) && this.getCause() != null) {
            return this.getCause().getLocalizedMessage();
        }
        return super.getLocalizedMessage();
    }

    @Override
    public String getMessage() {
        if (super.getMessage() == null || "".equals(super.getMessage()) && this.getCause() != null) {
            return this.getCause().getMessage();
        }
        return super.getMessage();
    }

    @Override
    public StackTraceElement[] getStackTrace() {
        if (super.getMessage() == null || "".equals(super.getMessage()) && this.getCause() != null) {
            return this.getCause().getStackTrace();
        }
        return super.getStackTrace();
    }
}

