/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta;

import org.xmeta.XMetaException;

public class Path {
    public static final byte TYPE_CATEGORY = 1;
    public static final byte TYPE_THING = 2;
    public static final byte TYPE_ATTRIBUTE = 3;
    public static final byte TYPE_CHILD_THINGS = 4;
    public static final byte TYPE_CHILD_THING_AT_INDEX = 5;
    public static final byte TYPE_CATEGORY_OR_THING = 6;
    public static final byte TYPE_CHILD_THING = 7;
    public static final byte TYPE_CHILD_THING_OR_INDEX = 8;
    public static final byte TYPE_CHILD_THING_BY_NAME = 9;
    public static final byte TYPE_RESOURCE_ID = 10;
    private String path = null;
    private byte type;
    private String thingName = null;
    private String attributeName = null;
    private String thingId = null;
    private short index = (short)-1;
    private Path childPath = null;

    private Path() {
    }

    public Path(String pathStr) {
        if (pathStr == null || "".equals(pathStr)) {
            throw new NullPointerException("path can not be null");
        }
        if (pathStr.indexOf(":") != -1) {
            String[] paths = pathStr.split(":");
            if (paths.length == 1) {
                this.path = paths[0];
                this.type = (byte)6;
            } else if (paths.length == 2) {
                this.path = paths[0] + "." + paths[1];
                this.type = (byte)6;
            } else if (paths.length == 3) {
                this.path = paths[0] + "." + paths[1] + "." + paths[2];
                this.type = (byte)6;
            } else {
                this.path = paths[0] + "." + paths[1] + "." + paths[2];
                this.type = (byte)2;
                Path parent = this;
                for (String childPath : paths[3].split("[/]")) {
                    Path child;
                    if ("".equals(childPath) || "@".equals(childPath) || (child = Path.parseOldChildPath(this.path, childPath)) == null) continue;
                    parent.childPath = child;
                    parent = child;
                }
            }
        } else {
            String[] paths = pathStr.split("[/]");
            this.path = paths[0];
            this.type = (byte)6;
            Path parent = this;
            for (int i = 1; i < paths.length; ++i) {
                String childPath = paths[i];
                Path child = Path.parseChildPath(this.path, childPath);
                if (child == null) continue;
                parent.childPath = child;
                parent = child;
            }
        }
    }

    public static Path parseChildPath(String path, String childPath) {
        Path child = null;
        if (childPath == null || childPath.equals("")) {
            return null;
        }
        if (childPath.startsWith("@")) {
            child = new Path();
            child.type = (byte)7;
            child.thingId = childPath.substring(1, childPath.length());
        } else if (childPath.startsWith("%")) {
            child = new Path();
            child.type = (byte)9;
            child.thingId = childPath.substring(1, childPath.length());
        } else if (childPath.startsWith("#")) {
            child = new Path();
            child.type = (byte)3;
            child.attributeName = childPath.substring(1, childPath.length());
        } else if (childPath.startsWith("!")) {
            child = new Path();
            child.type = (byte)10;
            child.attributeName = childPath.substring(1, childPath.length());
        } else if (childPath.startsWith("$")) {
            child = new Path();
            child.type = (byte)5;
            try {
                child.index = Short.parseShort(childPath.substring(1, childPath.length()));
            }
            catch (Exception e) {
                return null;
            }
        } else if (childPath.endsWith("$") || childPath.endsWith("@")) {
            child = new Path();
            child.type = (byte)4;
            child.thingName = childPath.substring(0, childPath.length() - 1);
        } else if (childPath.indexOf("$") != -1) {
            child = new Path();
            child.type = (byte)5;
            int index = childPath.indexOf("$");
            child.thingName = childPath.substring(0, index);
            try {
                child.index = Short.parseShort(childPath.substring(index + 1, childPath.length()));
            }
            catch (Exception e) {
                return null;
            }
        } else {
            return null;
        }
        if (child != null) {
            child.path = childPath;
        }
        return child;
    }

    public static Path parseOldChildPath(String path, String childPath) {
        Path child = null;
        if (childPath.startsWith("@")) {
            child = new Path();
            child.thingId = childPath.substring(1, childPath.length());
            child.type = (byte)8;
            try {
                child.index = Short.parseShort(child.thingId);
            }
            catch (Exception e) {
                child.index = (short)-1;
            }
        } else if (childPath.endsWith("@")) {
            child = new Path();
            child.thingName = childPath.substring(0, childPath.length() - 1);
            child.type = (byte)4;
        } else if (childPath.indexOf("@") != -1) {
            child = new Path();
            int index = childPath.indexOf("@");
            child.thingName = childPath.substring(0, index);
            child.thingId = childPath.substring(index + 1, childPath.length());
            child.type = (byte)8;
            try {
                child.index = Short.parseShort(child.thingId);
            }
            catch (Exception e) {
                child.index = (short)-1;
            }
        } else {
            throw new XMetaException("Invailid path, path=" + path);
        }
        if (child != null) {
            child.path = childPath;
        }
        return child;
    }

    public String getPath() {
        return this.path;
    }

    public byte getType() {
        return this.type;
    }

    public short getIndex() {
        return this.index;
    }

    public Path getChildPath() {
        return this.childPath;
    }

    public String toString() {
        return "Path [childPath=" + this.childPath + ", index=" + this.index + ", path=" + this.path + ", type=" + this.type + "]";
    }

    public String getThingName() {
        return this.thingName;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public String getThingId() {
        return this.thingId;
    }

    public void setType(byte type) {
        this.type = type;
    }
}

