/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta.codes;

import java.util.Objects;
import org.xmeta.Thing;

public class CoderUtils {
    public static final String ATTRIBUTE_CREATE_TIME = "th_createTime";
    static final ThreadLocal<Boolean> saveCreateTime = new ThreadLocal();

    static boolean isSaveCreateTime() {
        if (saveCreateTime.get() == null) {
            return false;
        }
        return saveCreateTime.get();
    }

    static void setSaveCreateTime(boolean saveCreateTime) {
        CoderUtils.saveCreateTime.set(saveCreateTime);
    }

    static void initCreateTime(Thing thing) {
        try {
            if (thing.valueExists(ATTRIBUTE_CREATE_TIME)) {
                thing.getMetadata().setCreateTime(thing.getLong(ATTRIBUTE_CREATE_TIME));
            } else {
                thing.getMetadata().setCreateTime(thing.getMetadata().getLastModified());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isDefault(Thing attribute, String value) {
        String defaultValue = attribute.getStringBlankAsNull("default");
        String type = attribute.getString("type");
        String inputtype = attribute.getString("inputtype");
        if ("truefalse".equals(inputtype)) {
            if (defaultValue == null) {
                defaultValue = "false";
            }
            if (defaultValue.equals(value)) {
                return true;
            }
            return defaultValue.equals("false") && (value == null || "".equals(value));
        }
        if (defaultValue == null && value != null && !"".equals(value)) {
            return false;
        }
        return Objects.equals(defaultValue, value);
    }
}

