/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta.codes;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.xmeta.Thing;
import org.xmeta.ThingCoder;
import org.xmeta.ThingCoderException;
import org.xmeta.ThingIndex;
import org.xmeta.World;
import org.xmeta.cache.ThingCache;
import org.xmeta.codes.CoderUtils;
import org.xmeta.codes.XmlCoder;

public class DmlThingCoder
implements ThingCoder {
    ThingCoder xmlThingCoder = null;
    ThingCoder txtThingCoder = null;
    ThingCoder propertyThingCoder = null;
    public static String TYPE = "dml";
    public static String TYPE_TXT = "dml_txt";
    public static String TYPE_XML = "dml_xml";
    public static String TYPE_PROPERTY = "dml_property";

    public DmlThingCoder(ThingCoder xmlThingCoder, ThingCoder txtThingCoder, ThingCoder propertyThingCoder) {
        this.xmlThingCoder = xmlThingCoder;
        this.txtThingCoder = txtThingCoder;
        this.propertyThingCoder = propertyThingCoder;
    }

    @Override
    public void encode(Thing thing, OutputStream out) {
        CoderUtils.setSaveCreateTime(true);
        try {
            if (TYPE_XML.equals(thing.getMetadata().getCoderType())) {
                this.xmlThingCoder.encode(thing, out);
            } else if (TYPE_PROPERTY.equals(thing.getMetadata().getCoderType())) {
                this.propertyThingCoder.encode(thing, out);
            } else {
                this.txtThingCoder.encode(thing, out);
            }
        }
        finally {
            CoderUtils.setSaveCreateTime(false);
        }
    }

    @Override
    public void decode(Thing thing, InputStream in, long lastModified) {
        try {
            BufferedInputStream bin;
            if (in.available() == 0) {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                if (thing.getMetadata().getThingManager() == World.getInstance().getClassThingManager()) {
                    byte[] bytes = new byte[8192];
                    int length = -1;
                    while ((length = in.read(bytes)) != -1) {
                        bout.write(bytes, 0, length);
                    }
                }
                if (bout.toByteArray().length == 0) {
                    return;
                }
                bin = new BufferedInputStream(new ByteArrayInputStream(bout.toByteArray()));
            } else {
                bin = new BufferedInputStream(in);
            }
            bin.mark(10);
            int firstChar = bin.read();
            bin.reset();
            if (firstChar == 94) {
                this.txtThingCoder.decode(thing, bin, lastModified);
                thing.getMetadata().setCoderType(TYPE_TXT);
            } else if (firstChar == 37) {
                this.propertyThingCoder.decode(thing, bin, lastModified);
                thing.getMetadata().setCoderType(TYPE_PROPERTY);
            } else {
                ThingCache.put(thing.getMetadata().getPath(), thing);
                this.xmlThingCoder.decode(thing, bin, lastModified);
                XmlCoder.initDefaultValues(thing);
                thing.getMetadata().setCoderType(TYPE_XML);
            }
            bin.close();
        }
        catch (Exception e) {
            String path = thing.getRoot().getMetadata().getPath();
            if (thing.getMetadata().getThingManager() != null) {
                path = thing.getMetadata().getThingManager().getName() + ":" + path;
            }
            throw new ThingCoderException(path, e);
        }
        CoderUtils.initCreateTime(thing);
    }

    @Override
    public void decodeIndex(ThingIndex thingIndex, InputStream in, long lastModifyed) {
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public boolean acceptType(String type) {
        return TYPE.equals(type) || TYPE_TXT.equals(type) || TYPE_XML.equals(type) || TYPE_PROPERTY.equals(type);
    }

    @Override
    public String[] getCodeTypes() {
        return new String[]{TYPE_XML, TYPE_PROPERTY, TYPE_TXT};
    }
}

