/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta.codes;

import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xmeta.Thing;
import org.xmeta.ThingCoder;
import org.xmeta.ThingCoderException;
import org.xmeta.ThingIndex;
import org.xmeta.codes.CoderUtils;
import org.xmeta.codes.XmlCoder;

public class XmlThingCoder
implements ThingCoder {
    public static String TYPE = "dml.xml";

    @Override
    public void decode(Thing thing, InputStream in, long lastModified) {
        CoderUtils.setSaveCreateTime(true);
        try {
            String lm;
            Document document = null;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse(in);
            Element root = document.getDocumentElement();
            if (lastModified == 0L && (lm = root.getAttribute("lastModified")) != null && !lm.isEmpty()) {
                try {
                    SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    lastModified = sf.parse(lm).getTime();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            XmlCoder.parse(thing, null, root, lastModified);
            XmlCoder.setLastModified(thing, lastModified);
            CoderUtils.initCreateTime(thing);
        }
        catch (Exception e) {
            throw new ThingCoderException(e);
        }
        finally {
            CoderUtils.setSaveCreateTime(false);
        }
    }

    @Override
    public void decodeIndex(ThingIndex thingIndex, InputStream in, long lastModified) {
        try {
            Document document = null;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse(in);
            Element root = document.getDocumentElement();
            thingIndex.descriptors = root.getAttribute("descriptors");
            thingIndex.description = root.getAttribute("description");
            thingIndex.name = root.getAttribute("name");
            thingIndex.label = root.getAttribute("label");
            thingIndex.lastModified = lastModified;
        }
        catch (Exception e) {
            throw new ThingCoderException(e);
        }
    }

    @Override
    public void encode(Thing thing, OutputStream out) {
        CoderUtils.setSaveCreateTime(true);
        try {
            if (!thing.valueExists("th_createTime")) {
                thing.getAttributes().put("the_createTime", thing.getMetadata().getCreateTime());
            }
            XmlCoder.encode(thing, out);
        }
        catch (Exception e) {
            throw new ThingCoderException(e);
        }
        finally {
            CoderUtils.setSaveCreateTime(false);
        }
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public boolean acceptType(String type) {
        return TYPE.equals(type);
    }

    @Override
    public String[] getCodeTypes() {
        return new String[]{TYPE};
    }
}

