/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xmeta.Thing;
import org.xmeta.World;

public class ThingClassLoader
extends URLClassLoader {
    private static final Logger logger = Logger.getLogger(ThingClassLoader.class.getName());
    List<Lib> libs = new ArrayList<Lib>();

    public ThingClassLoader(URL[] urls) {
        super(urls);
    }

    public ThingClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    public ThingClassLoader(ClassLoader parent) {
        super(new URL[0], parent);
        World world = World.getInstance();
        String worldPath = world.getPath();
        for (String lib : world.getLibList()) {
            File libFile = new File(lib);
            this.addJarOrZip(libFile);
        }
        File libFile = new File(worldPath + "/lib/");
        this.addJarOrZip(libFile);
        this.addJarOrZip(new File(worldPath + "/os/lib/lib_" + world.getOS()));
        this.addJarOrZip(new File(worldPath + "/os/lib/lib_" + world.getOS() + "_" + world.getJVMBit()));
    }

    public void initLibs() {
        Thing config = World.getInstance().getThing("_local.xworker.config.GlobalConfig");
        while (this.libs.size() > 0) {
            int index2;
            int index1;
            Lib lib = this.libs.remove(0);
            String filePath = lib.path;
            while ((index1 = filePath.indexOf("'")) != -1 && (index2 = filePath.indexOf("'", index1 + 1)) != -1) {
                String replacement;
                String replaceFor = filePath.substring(index1 + 1, index2);
                String string = replacement = config != null ? config.getString(replaceFor) : "";
                if (replacement == null) {
                    replacement = "";
                }
                filePath = this.replaceAll(filePath, replaceFor, replacement);
            }
            File file = new File(filePath);
            if ("lib".equals(lib.type)) {
                this.addJarOrZip(file);
                continue;
            }
            if (!file.exists()) continue;
            try {
                this.addURL(file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
    }

    private String replaceAll(String str, String replaceFor, String replacement) {
        int index2;
        int index1;
        String fstr = str;
        while ((index1 = fstr.indexOf("'" + replaceFor)) != -1 && (index2 = fstr.indexOf(replaceFor + "'")) != -1) {
            fstr = fstr.substring(0, index1) + replacement + fstr.substring(index2 + replaceFor.length() + 1, fstr.length());
        }
        return fstr;
    }

    public void addJarOrZip(File dir) {
        if (!dir.exists()) {
            return;
        }
        if (dir.isDirectory()) {
            for (File file : dir.listFiles()) {
                this.addJarOrZip(file);
            }
        } else {
            String fileName = dir.getName().toLowerCase();
            if (fileName.endsWith(".jar") || fileName.endsWith(".zip")) {
                try {
                    this.addURL(dir.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            } else if (fileName.endsWith(".lib")) {
                this.initLib(dir);
            }
        }
    }

    public void addClassPath(URL url) {
        if (url != null) {
            this.addURL(url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initLib(File file) {
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(file);
            BufferedReader br = new BufferedReader(new InputStreamReader(fin));
            String line = null;
            while ((line = br.readLine()) != null) {
                String[] ls = (line = line.trim()).split("[=]");
                if (ls.length != 2) continue;
                ls[0] = ls[0].trim();
                ls[1] = ls[1].trim();
                if ("".equals(ls[0])) continue;
                if (!"lib".equals(ls[0]) && !"path".equals(ls[0])) {
                    logger.info("unkown lib type, only 'lib' or 'path' suppored, line=" + line + ",libFile=" + file.getAbsolutePath());
                    continue;
                }
                this.libs.add(new Lib(ls[0], ls[1]));
            }
            br.close();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "init lib error", e);
        }
        finally {
            try {
                if (fin != null) {
                    fin.close();
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    public String getClassPath() {
        HashMap<String, String> context = new HashMap<String, String>();
        String javaClassPath = System.getProperty("java.class.path");
        String path = ThingClassLoader.getClassPathFormClassLoader(this, "", context);
        return javaClassPath + File.pathSeparator + path;
    }

    public List<String> getAllClassPathDirs() {
        return this.getAlClassPathDirs();
    }

    public List<String> getAlClassPathDirs() {
        HashMap<String, String> dirContext = new HashMap<String, String>();
        for (String path : this.getClassPath().split("[" + File.pathSeparator + "]")) {
            File file;
            if (path.trim().equals("") || !(file = new File(path)).exists() || !file.isDirectory()) continue;
            dirContext.put(file.getPath(), file.getPath());
        }
        ArrayList<String> jars = new ArrayList<String>();
        for (String path : dirContext.keySet()) {
            jars.add(path);
        }
        Collections.sort(jars);
        return jars;
    }

    public List<String> getAllJarsByName() {
        HashMap<String, String> jarContext = new HashMap<String, String>();
        for (String path : this.getClassPath().split("[" + File.pathSeparator + "]")) {
            if (!path.toLowerCase().endsWith(".jar")) continue;
            int index = -1;
            index = path.contains("/") ? path.lastIndexOf("/") : path.lastIndexOf("\\");
            if (index != -1) {
                path = path.substring(index + 1);
            }
            jarContext.put(path, path);
        }
        ArrayList<String> jars = new ArrayList<String>(jarContext.keySet());
        Collections.sort(jars);
        return jars;
    }

    public List<String> getAllClassPaths() {
        HashMap<String, String> context = new HashMap<String, String>();
        for (String path : this.getClassPath().split("[" + File.pathSeparator + "]")) {
            context.put(path, path);
        }
        ArrayList<String> jars = new ArrayList<String>(context.keySet());
        Collections.sort(jars);
        return jars;
    }

    public static String getClassPathFormClassLoader(URLClassLoader loader, String classPath, Map<String, String> context) {
        for (URL url : loader.getURLs()) {
            String filePath = url.getFile();
            if (filePath == null || context.get(filePath) != null || "".equals(filePath)) continue;
            context.put(filePath, filePath);
            classPath = classPath == null ? filePath : classPath + File.pathSeparator + filePath;
        }
        ClassLoader parent = loader.getParent();
        if (parent instanceof URLClassLoader) {
            classPath = ThingClassLoader.getClassPathFormClassLoader((URLClassLoader)parent, classPath, context);
        }
        return classPath;
    }

    public String getCompileClassPath() {
        return this.getClassPath();
    }

    static class Lib {
        String type;
        String path;

        public Lib(String type, String path) {
            this.type = type;
            this.path = path;
        }
    }
}

