/*
 * Decompiled with CFR 0.152.
 */
package x2br.mangaba;

import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import x2br.mangaba.template.impl.HtmlEngine;
import x2br.mangaba.template.model.FeatureModel;
import x2br.mangaba.template.model.ScenarioModel;
import x2br.mangaba.template.model.StepModel;
import x2br.mangaba.template.model.SummaryReportModel;
import x2br.mangaba.template.model.UnitTestModel;
import x2br.mangaba.util.MangabaUtil;

public class Mangaba {
    private static Mangaba mangabaInstance = null;
    private static int id = 1;
    private static ResourceBundle rb = ResourceBundle.getBundle("i18n/mangaba");
    private Map<String, SummaryReportModel> summaryReportMap;
    private SummaryReportModel suiteSummaryReportModel;

    private Mangaba() {
        System.out.println("******** START MANGABA *******");
        this.summaryReportMap = new HashMap<String, SummaryReportModel>();
    }

    public static Mangaba getInstance() {
        if (null == mangabaInstance) {
            mangabaInstance = new Mangaba();
        }
        return mangabaInstance;
    }

    public SummaryReportModel getSummaryReportModel(Class testClassName) {
        if (!this.summaryReportMap.containsKey(testClassName)) {
            System.out.println("CRIANDO getSummaryReportModel:" + testClassName.getSimpleName());
            this.summaryReportMap.put(testClassName.getName(), new SummaryReportModel(id++, new Date(), "App01", "v1.0.0", testClassName.getSimpleName()));
        }
        return this.summaryReportMap.get(testClassName.getName());
    }

    public SummaryReportModel getSuiteSummaryReportModel() {
        return this.suiteSummaryReportModel;
    }

    public SummaryReportModel createSuiteSummaryReportModel(Class testClassName) {
        if (!this.hasSuiteSummaryReportModel()) {
            this.suiteSummaryReportModel = new SummaryReportModel(id++, new Date(), "App01", "v1.0.0", testClassName.getSimpleName());
        }
        return this.suiteSummaryReportModel;
    }

    public FeatureModel createFeatureModel(String name, String methodName, String description) {
        return new FeatureModel(id++, name, methodName, description);
    }

    public ScenarioModel createScenarioModel(String methodName, String description) {
        return new ScenarioModel(id++, methodName, description);
    }

    public StepModel createStepModell(String description, int duration) {
        return new StepModel(id++, description, duration);
    }

    public UnitTestModel createUnitTestModell(String testClassName, String name, int duration, boolean passed) {
        return new UnitTestModel(id++, testClassName, name, duration, passed);
    }

    public void clearSummaryReportModel() {
        System.out.println("******** CLEAN SUITE SUMMARY REPORT *******");
        this.suiteSummaryReportModel = null;
    }

    public void clearSummaryReportModel(Class testClassName) {
        System.out.println("******** CLEAN SUMMARY REPORT *******:" + testClassName.getName());
        this.summaryReportMap.remove(testClassName.getName());
    }

    public boolean hasSuiteSummaryReportModel() {
        return this.suiteSummaryReportModel != null;
    }

    public static String getI18nValue(String key) {
        return rb.getString(key);
    }

    public void generateSuiteReport(String featureName) {
        if (this.suiteSummaryReportModel != null) {
            HashMap<String, SummaryReportModel> params = new HashMap<String, SummaryReportModel>();
            this.suiteSummaryReportModel.process();
            params.put("srm", this.suiteSummaryReportModel);
            HtmlEngine engine = new HtmlEngine();
            String result = engine.merge("mangaba_report_template.html", params);
            try {
                MangabaUtil.write(this.suiteSummaryReportModel.getTestClassName(), "Report_" + featureName + ".html", result);
            }
            catch (IOException ex) {
                Logger.getLogger(HtmlEngine.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void generateSpecificationReport(String featureName) {
        if (this.summaryReportMap.containsKey(featureName)) {
            SummaryReportModel srm = this.summaryReportMap.get(featureName);
            HashMap<String, SummaryReportModel> params = new HashMap<String, SummaryReportModel>();
            srm.process();
            params.put("srm", srm);
            HtmlEngine engine = new HtmlEngine();
            String result = engine.merge("mangaba_report_template.html", params);
            try {
                if (this.hasSuiteSummaryReportModel()) {
                    MangabaUtil.write(this.suiteSummaryReportModel.getTestClassName(), "Report_" + featureName + ".html", result);
                } else {
                    MangabaUtil.write("", "Report_" + featureName + ".html", result);
                }
            }
            catch (IOException ex) {
                Logger.getLogger(HtmlEngine.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

