/*
 * Decompiled with CFR 0.152.
 */
package x2br.mangaba;

import x2br.mangaba.ParamFactory;
import x2br.mangaba.factories.NoneParaFactory;
import x2br.mangaba.factories.ParamFactories;

public class Param<T> {
    String name;
    Object value;
    Class<T> type;
    Class<? extends ParamFactory> factory;
    String factoryName;
    private boolean hide;

    public Param(String name, Class<T> type) {
        this(name, type, NoneParaFactory.class, "");
    }

    public Param(String name, Class<T> type, Class<? extends ParamFactory> factory, String factoryName) {
        this.name = name;
        this.type = type;
        this.factory = factory;
        this.factoryName = factoryName;
        this.hide = false;
    }

    public <T> T value() {
        if (!this.factoryName.equals("")) {
            try {
                return ParamFactories.getValue(this.factoryName, this.value.toString());
            }
            catch (Throwable ex) {
                throw new RuntimeException(ex);
            }
        }
        return ParamFactories.getValue(this.type, this.value.toString());
    }

    public String getName() {
        return this.name;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Class<T> getType() {
        return this.type;
    }

    public Class<?> getFactory() {
        return this.factory;
    }

    public boolean isHide() {
        return this.hide;
    }

    public void setHide(boolean hide) {
        this.hide = hide;
    }

    public String toString() {
        try {
            StringBuilder sb = new StringBuilder();
            if (!this.hide) {
                sb.append("<strong>".concat(this.name).concat(" </strong>"));
            }
            sb.append("<span class=\"label label-primary\">").append(this.value.toString()).append("</span>");
            return sb.toString();
        }
        catch (Exception e) {
            return this.name;
        }
    }
}

