/*
 * Decompiled with CFR 0.152.
 */
package x2br.mangaba;

import x2br.mangaba.MangabaTestStatusEnum;
import x2br.mangaba.Operable;
import x2br.mangaba.Operator;
import x2br.mangaba.factories.ParamFactories;

public class Result
implements Operable {
    String name;
    Operator operator;
    Object value;
    Class resultClass;
    private MangabaTestStatusEnum status = MangabaTestStatusEnum.PENDING;

    public Result(String name, Class resultClass) {
        this.name = name;
        this.resultClass = resultClass;
    }

    public Object value() {
        if (this.operator.getValue() instanceof Throwable) {
            return this.operator.getValue();
        }
        return ParamFactories.getValue(this.resultClass, (String)this.operator.getValue());
    }

    public MangabaTestStatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(MangabaTestStatusEnum status) {
        this.status = status;
    }

    public String getName() {
        return this.name;
    }

    public boolean isPassed() {
        return this.status.equals((Object)MangabaTestStatusEnum.PASSED);
    }

    public void setPassed() {
        this.status = MangabaTestStatusEnum.PASSED;
    }

    public boolean isFailed() {
        return this.status.equals((Object)MangabaTestStatusEnum.FAILED);
    }

    public void setFailed() {
        this.status = MangabaTestStatusEnum.FAILED;
    }

    public boolean isSkipped() {
        return this.status.equals((Object)MangabaTestStatusEnum.SKIPPED);
    }

    public void setSkipped() {
        this.status = MangabaTestStatusEnum.SKIPPED;
    }

    public boolean isPending() {
        return this.status.equals((Object)MangabaTestStatusEnum.PENDING);
    }

    public void setPending() {
        this.status = MangabaTestStatusEnum.PENDING;
    }

    public Class getResultClass() {
        return this.resultClass;
    }

    public String outputValue() {
        String outValue;
        String string = outValue = this.operator.getValue() != null ? this.operator.getValue().toString() : null;
        outValue = this.isPassed() ? "<span class=\"label label-success\">" + outValue + "</span>" : (this.isFailed() ? "<span class=\"label label-danger\"><s>" + outValue + "</s></span>" : (this.isSkipped() ? "<span class=\"label label-warning\">" + outValue + "</span>" : "<span class=\"label label-info\">" + outValue + "</span>"));
        return outValue;
    }

    public String toString() {
        return this.operator.getName() + this.outputValue();
    }

    @Override
    public void setOperator(Operator operator) {
        this.operator = operator;
    }

    @Override
    public Operator getOperator() {
        return this.operator;
    }
}

