/*
 * Decompiled with CFR 0.152.
 */
package x2br.mangaba;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import x2br.mangaba.Operator;
import x2br.mangaba.Param;
import x2br.mangaba.Result;
import x2br.mangaba.ResultProperty;
import x2br.mangaba.TableHeader;
import x2br.mangaba.util.MangabaUtil;

public class Table {
    TableHeader tableHeader;
    List<List<Result>> resultRows;
    List<List<Param>> inputRows;
    String name;
    private Class resultClass;
    private Map<String, Param> paramMap;
    private boolean inOutTable = false;

    public Table(String tableName, Class resultClass) {
        this(tableName, resultClass, false, null);
    }

    public Table(String tableName, Class resultClass, boolean inOutTable, Map<String, Param> paramMap) {
        this.name = tableName;
        this.resultClass = resultClass;
        this.tableHeader = new TableHeader(this);
        this.resultRows = new ArrayList<List<Result>>();
        this.inputRows = new ArrayList<List<Param>>();
        this.inOutTable = inOutTable;
        this.paramMap = paramMap;
    }

    public boolean isInOutTable() {
        return this.inOutTable;
    }

    public String getName() {
        return this.name;
    }

    public int colsCount() {
        return this.tableHeader.colsCount();
    }

    public int resultColsCount() {
        return this.tableHeader.resultColsCount();
    }

    public TableHeader getTableHeader() {
        return this.tableHeader;
    }

    public int rowsCount() {
        return this.resultRows.size();
    }

    public boolean isEmpty() {
        return this.resultRows.isEmpty();
    }

    public void addResultRow(List<Result> row) {
        this.resultRows.add(row);
    }

    public List<Result> getResultRow(int index) {
        return this.resultRows.get(index);
    }

    public List<List<Result>> getResultRows() {
        return this.resultRows;
    }

    public List<Param> getInputRow(int index) {
        return this.inputRows.get(index);
    }

    public List<List<Param>> getInputRows() {
        return this.inputRows;
    }

    public Table addRow(Object ... columnValues) {
        System.out.println("Ini add lina:" + columnValues);
        Result res = null;
        ArrayList<Result> row = new ArrayList<Result>();
        ArrayList inputRow = new ArrayList();
        for (int i = 0; i < this.colsCount(); ++i) {
            System.out.println("**\n**\ncolumnValues[i]:" + columnValues[i] + "\n**");
            Class type = this.tableHeader.getColType(i);
            if (type == Result.class || type == ResultProperty.class) {
                if (type == Result.class) {
                    res = new Result(this.resultClass.getName(), this.resultClass);
                } else if (type == ResultProperty.class) {
                    res = new ResultProperty(this.tableHeader.getColName(i), this.resultClass);
                }
                Operator opx = new Operator(this.tableHeader.getColOperator(i));
                opx.setValue(columnValues[i]);
                res.setOperator(opx);
                row.add(res);
                continue;
            }
            if (type != Param.class || this.paramMap == null || !this.paramMap.containsKey(this.tableHeader.getColName(i))) continue;
            Param p = this.paramMap.get(this.tableHeader.getColName(i));
            Param fake = new Param(p.name, p.type, p.factory, p.factoryName);
            fake.setHide(true);
            fake.setValue(columnValues[i]);
            inputRow.add(fake);
        }
        this.resultRows.add(row);
        this.inputRows.add(inputRow);
        System.out.println("Fim add linha");
        return this;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("<h2>" + this.name + "</h2><p><div class=\"table-responsive\">").append("<table class=\"table table-striped\"><thead><tr>");
        for (String colName : this.tableHeader.getColNames()) {
            buf.append("<th>").append(MangabaUtil.toTitleCase(colName)).append("</th>");
        }
        buf.append("</tr></thead><tbody>");
        for (int i = 0; i < this.resultRows.size(); ++i) {
            List<Result> row = this.resultRows.get(i);
            buf.append("<tr>");
            for (Param p : this.inputRows.get(i)) {
                buf.append("<td>").append(p.toString()).append("</td>");
            }
            for (Result o : row) {
                buf.append("<td>").append(o.outputValue()).append("</td>");
            }
            buf.append("</tr>");
        }
        buf.append("</tbody></table></div>");
        return buf.toString();
    }
}

