/*
 * Decompiled with CFR 0.152.
 */
package x2br.mangaba;

import java.util.ArrayList;
import java.util.List;
import x2br.mangaba.Operator;
import x2br.mangaba.Param;
import x2br.mangaba.Result;
import x2br.mangaba.ResultProperty;
import x2br.mangaba.Table;

public class TableHeader {
    private final List<Class> colTypes = new ArrayList<Class>();
    private final List<String> colNames = new ArrayList<String>();
    private List<Operator.OperatorEnum> colOperators = new ArrayList<Operator.OperatorEnum>();
    private final Table table;

    public TableHeader(Table table) {
        this.table = table;
    }

    public void addCol(String colName, Class colType, Operator.OperatorEnum operator) {
        try {
            this.colNames.add(colName);
            this.colTypes.add(colType);
            this.colOperators.add(operator);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public List<String> getInputColNames() {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < this.colTypes.size(); ++i) {
            if (this.colTypes.get(i) != Param.class) continue;
            list.add(this.colNames.get(i));
        }
        return list;
    }

    public int inputColsCount() {
        return this.getInputColNames().size();
    }

    public int resultColsCount() {
        return this.getResultColNames().size();
    }

    public List<Class> getInputColTypes() {
        ArrayList<Class> list = new ArrayList<Class>();
        for (Class type : this.colTypes) {
            if (type != Param.class) continue;
            list.add(type);
        }
        return list;
    }

    public List<String> getResultColNames() {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < this.colTypes.size(); ++i) {
            if (this.colTypes.get(i) != Result.class && this.colTypes.get(i) != ResultProperty.class) continue;
            list.add(this.colNames.get(i));
        }
        return list;
    }

    public List<Class> getResultColTypes() {
        ArrayList<Class> list = new ArrayList<Class>();
        for (Class type : this.colTypes) {
            if (type != Result.class && type != ResultProperty.class) continue;
            list.add(type);
        }
        return list;
    }

    public List<Class> getColTypes() {
        return this.colTypes;
    }

    public List<String> getColNames() {
        return this.colNames;
    }

    public List<Operator.OperatorEnum> getColOperators() {
        return this.colOperators;
    }

    public Class getColType(int index) {
        return this.colTypes.get(index);
    }

    public String getColName(int index) {
        return this.colNames.get(index);
    }

    public Operator.OperatorEnum getColOperator(int index) {
        return this.colOperators.get(index);
    }

    public void setColoperators(List<Operator.OperatorEnum> colOperators) {
        this.colOperators = colOperators;
    }

    public int colsCount() {
        return this.colNames.size();
    }

    public Table getTable() {
        return this.table;
    }
}

