/*
 * Decompiled with CFR 0.152.
 */
package x2br.mangaba.builders;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.runners.model.InitializationError;
import x2br.mangaba.Operable;
import x2br.mangaba.Operator;
import x2br.mangaba.Param;
import x2br.mangaba.Result;
import x2br.mangaba.ResultProperty;
import x2br.mangaba.Table;
import x2br.mangaba.TableHeader;
import x2br.mangaba.annotations.Specification;
import x2br.mangaba.template.model.FeatureModel;
import x2br.mangaba.template.model.ScenarioModel;

public class ExampleBuilder {
    private Class testClass;
    protected Class resultClass;
    protected Method method;
    protected List<Param> fbParamList = new ArrayList<Param>();
    private List<Object> feature;
    protected Map<String, Param> paramMap;
    protected Map<String, Result> multiValueResultMap;
    private Object result;
    private List<AssertionError> assertionErrors;
    private ExampleBuilder sb;
    protected FeatureModel fm = null;
    private ScenarioModel sm = null;
    protected String scenarioMethodName;
    protected Table withResultListInTable = null;

    public ExampleBuilder(Class testClass, String scenarioMethodName, FeatureModel fm) {
        try {
            this.scenarioMethodName = scenarioMethodName;
            this.testClass = testClass;
            this.fm = fm;
            this.sb = this;
            this.initParams();
        }
        catch (InitializationError ex) {
            Logger.getLogger(ExampleBuilder.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public boolean isVoidReturnType() {
        return this.resultClass.equals(Void.TYPE);
    }

    private void initParams() throws InitializationError {
        this.paramMap = new HashMap<String, Param>();
        this.assertionErrors = new ArrayList<AssertionError>();
        this.fbParamList = this.fbParamList;
        this.multiValueResultMap = new HashMap<String, Result>();
        this.feature = new ArrayList<Object>();
        for (Method method : this.testClass.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(Specification.class)) continue;
            this.method = method;
            break;
        }
        this.resultClass = this.realReturnClass();
        for (AnnotatedElement annotatedElement : this.method.getParameters()) {
            if (!annotatedElement.isAnnotationPresent(x2br.mangaba.annotations.Param.class)) {
                throw new InitializationError("Exception during initialization with a method that must have the parameters annotated with @Param(name=\"paramenterName\").");
            }
            x2br.mangaba.annotations.Param param = ((Parameter)annotatedElement).getDeclaredAnnotation(x2br.mangaba.annotations.Param.class);
            this.fbParamList.add(new Param(param.name(), ((Parameter)annotatedElement).getType(), param.createWith(), param.factoryName()));
        }
        for (Param p : this.fbParamList) {
            this.paramMap.put(p.getName(), p);
        }
    }

    public ExampleBuilder text(String text) {
        this.feature.add(text);
        return this;
    }

    public ExampleBuilder param(String name, Object value) {
        return this.param(name, value, false);
    }

    public ExampleBuilder param(String name, Object value, boolean hideParamName) {
        if (this.paramMap.containsKey(name)) {
            Param p = this.paramMap.get(name);
            p.setHide(hideParamName);
            p.setValue(value);
            this.feature.add(p);
            return this;
        }
        return null;
    }

    public OperatorBuilder result() {
        Result result = new Result(this.resultClass.getSimpleName(), this.resultClass);
        OperatorBuilder op = new OperatorBuilder(result);
        this.feature.add(result);
        this.multiValueResultMap.put(this.resultClass.getSimpleName(), result);
        return op;
    }

    public OperatorBuilder resultProperty(String propertyName) {
        ResultProperty result = new ResultProperty(propertyName, this.resultClass);
        OperatorBuilder op = new OperatorBuilder(result);
        this.feature.add(result);
        this.multiValueResultMap.put(result.getName(), result);
        return op;
    }

    public TableBuilder withResultListInTable(String tableName) {
        TableBuilder table = new TableBuilder(tableName);
        this.feature.add(table.table);
        this.withResultListInTable = table.table;
        return table;
    }

    public TableBuilder eachRowAsAnExampleInTable(String tableName) {
        TableBuilder table = new TableBuilder(tableName, true);
        this.feature.add(table.table);
        this.withResultListInTable = table.table;
        return table;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        boolean hasSpace = false;
        try {
            for (Object ob : this.feature) {
                if (hasSpace && ob.toString().startsWith(" ")) {
                    buf.append(ob.toString().substring(1));
                } else {
                    buf.append(ob.toString());
                }
                hasSpace = ob.toString().endsWith(" ");
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return buf.toString();
    }

    public Object[] getParams() {
        Object[] ps = new Object[this.fbParamList.size()];
        for (int i = 0; i < ps.length; ++i) {
            ps[i] = this.paramMap.get(this.fbParamList.get(i).getName()).value();
        }
        return ps;
    }

    private Class realReturnClass() {
        ParameterizedType paramType;
        Type[] argTypes;
        Type returnType;
        Class<?> resultClass = this.method.getReturnType();
        if (Collection.class.isAssignableFrom(resultClass) && (returnType = this.method.getGenericReturnType()) instanceof ParameterizedType && (argTypes = (paramType = (ParameterizedType)returnType).getActualTypeArguments()).length > 0) {
            return (Class)argTypes[0];
        }
        return resultClass;
    }

    public class TableHeaderBuilder {
        TableBuilder tb;
        TableHeader th;

        public TableHeaderBuilder(TableBuilder tb) {
            System.out.println("Criando TableHeaderBuilder:" + tb.table.getName());
            this.tb = tb;
            this.th = tb.table.getTableHeader();
            System.out.println("FIM Criando TableHeaderBuilder:" + tb.table.getName());
        }

        public TableHeaderBuilder addColummInputName(String name) {
            System.out.println("TableHeaderBuilder addColummInputName:" + name);
            this.th.addCol(name, Param.class, null);
            return this;
        }

        public TableHeaderBuilder addColummResultName(String name, Operator.OperatorEnum operator) {
            System.out.println("TableHeaderBuilder addColummResultName:" + name + "  =>" + operator.getName());
            this.th.addCol(name, Result.class, operator);
            return this;
        }

        public TableHeaderBuilder addColummResultPropertyName(String name, Operator.OperatorEnum operator) {
            System.out.println("TableHeaderBuilder addColummResultPropertyName:" + name + "  =>" + operator.getName());
            try {
                this.th.addCol(name, ResultProperty.class, operator);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
            return this;
        }

        public TableBuilder endHeader() {
            return this.tb;
        }
    }

    public class TableBuilder {
        TableHeaderBuilder thb;
        Table table;

        public TableBuilder(String tableName) {
            this(tableName, false);
        }

        public TableBuilder(String tableName, boolean isInOutTable) {
            System.out.println("Criando TableBuilder:" + tableName);
            this.table = new Table(tableName, ExampleBuilder.this.resultClass, isInOutTable, ExampleBuilder.this.paramMap);
            this.thb = new TableHeaderBuilder(this);
            System.out.println("Fim Criando TableBuilder:" + tableName);
        }

        public ExampleBuilder endTable() {
            return ExampleBuilder.this.sb;
        }

        public TableHeaderBuilder withHeader() {
            return this.thb;
        }

        public TableBuilder addRow(Object ... columnValues) {
            System.out.println("TableBuilder addRow:" + columnValues);
            this.table.addRow(columnValues);
            return this;
        }
    }

    public class OperatorBuilder {
        Operator op;
        Operable operable;
        private boolean hideOperatorName;

        public OperatorBuilder(Operable operable) {
            this(operable, false);
        }

        public OperatorBuilder(Operable operable, boolean hideOperatorName) {
            this.operable = operable;
            this.hideOperatorName = hideOperatorName;
        }

        public ExampleBuilder expectedException(Class<? extends Throwable> throwableClass) {
            this.op = new Operator(Operator.OperatorEnum.EXCEPTION);
            this.op.setHide(this.hideOperatorName);
            try {
                this.op.setValue(throwableClass.newInstance());
            }
            catch (IllegalAccessException | InstantiationException ex) {
                Logger.getLogger(ExampleBuilder.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.operable.setOperator(this.op);
            return ExampleBuilder.this.sb;
        }

        public ExampleBuilder equalTo(Object value) {
            this.op = new Operator(Operator.OperatorEnum.EQUAL_TO);
            this.op.setHide(this.hideOperatorName);
            this.op.setValue(value);
            this.operable.setOperator(this.op);
            return ExampleBuilder.this.sb;
        }

        public ExampleBuilder notEqualTo(Object value) {
            this.op = new Operator(Operator.OperatorEnum.NOT_EQUAL_TO);
            this.op.setHide(this.hideOperatorName);
            this.op.setValue(value);
            this.operable.setOperator(this.op);
            return ExampleBuilder.this.sb;
        }

        public ExampleBuilder lessThan(Object value) {
            this.op = new Operator(Operator.OperatorEnum.LESS_THAN);
            this.op.setHide(this.hideOperatorName);
            this.op.setValue(value);
            this.operable.setOperator(this.op);
            return ExampleBuilder.this.sb;
        }

        public ExampleBuilder greaterThan(Object value) {
            this.op = new Operator(Operator.OperatorEnum.GREATER_THAN);
            this.op.setHide(this.hideOperatorName);
            this.op.setValue(value);
            this.operable.setOperator(this.op);
            return ExampleBuilder.this.sb;
        }

        public ExampleBuilder lessOrEqualTo(Object value) {
            this.op = new Operator(Operator.OperatorEnum.LESS_OR_EQUAL_TO);
            this.op.setHide(this.hideOperatorName);
            this.op.setValue(value);
            this.operable.setOperator(this.op);
            return ExampleBuilder.this.sb;
        }

        public ExampleBuilder greaterOrEqualTo(Object value) {
            this.op = new Operator(Operator.OperatorEnum.GREATER_OR_EQUAL_TO);
            this.op.setHide(this.hideOperatorName);
            this.op.setValue(value);
            this.operable.setOperator(this.op);
            return ExampleBuilder.this.sb;
        }
    }
}

