/*
 * Decompiled with CFR 0.152.
 */
package x2br.mangaba.builders;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.Assert;
import x2br.mangaba.Mangaba;
import x2br.mangaba.Operator;
import x2br.mangaba.Param;
import x2br.mangaba.Result;
import x2br.mangaba.ResultProperty;
import x2br.mangaba.Table;
import x2br.mangaba.annotations.Specification;
import x2br.mangaba.builders.ExampleBuilder;
import x2br.mangaba.template.model.FeatureModel;
import x2br.mangaba.template.model.ScenarioModel;
import x2br.mangaba.template.model.StepModel;

public class ExampleEvaluator {
    private final List<Param> fbParamList;
    private final Map<String, Param> paramMap;
    private final Class resultClass;
    private final Table withResultListInTable;
    private final String scenarioMethodName;
    private List<AssertionError> assertionErrors;
    private final Map<String, Result> multiValueResultMap;
    private List<StepModel> stepList = null;
    private FeatureModel fm = null;
    private ScenarioModel sm = null;
    private ExampleBuilder sb = null;

    public ExampleEvaluator(ExampleBuilder sb) {
        System.out.println("ESTOU NO EVALUATOR!!!!!!!");
        this.sb = sb;
        this.fbParamList = sb.fbParamList;
        this.resultClass = this.realReturnClass(sb.resultClass);
        this.paramMap = sb.paramMap;
        this.withResultListInTable = sb.withResultListInTable;
        this.scenarioMethodName = sb.scenarioMethodName;
        this.assertionErrors = new ArrayList<AssertionError>();
        this.multiValueResultMap = sb.multiValueResultMap;
        this.fm = sb.fm;
        this.stepList = new ArrayList<StepModel>();
    }

    private Class realReturnClass(Class resultClass) {
        ParameterizedType paramType;
        Type[] argTypes;
        Type returnType;
        if (Collection.class.isAssignableFrom(resultClass) && (returnType = this.sb.method.getGenericReturnType()) instanceof ParameterizedType && (argTypes = (paramType = (ParameterizedType)returnType).getActualTypeArguments()).length > 0) {
            System.out.println("Generic type is " + argTypes[0].getClass().getName());
            return (Class)argTypes[0];
        }
        return resultClass;
    }

    public Object[] getParams() {
        Object[] ps = new Object[this.fbParamList.size()];
        for (int i = 0; i < ps.length; ++i) {
            ps[i] = this.paramMap.get(this.fbParamList.get(i).getName()).value();
        }
        return ps;
    }

    public FeatureModel getFm() {
        return this.fm;
    }

    private void evaluateResult(Object result) {
        for (Result res : this.multiValueResultMap.values()) {
            Object expected;
            Object actual;
            if (res instanceof ResultProperty) {
                actual = this.getFieldOfResult(result, res.getName());
                expected = res.value();
                this.evaluateResult(expected, actual, res.getOperator().getSymbol(), res, this.stepList);
                continue;
            }
            actual = result;
            expected = res.value();
            this.evaluateResult(expected, actual, res.getOperator().getSymbol(), res, this.stepList);
        }
    }

    private void evaluateResultListInEmptyTable(List<Object> results) {
        for (Object result : results) {
            this.evaluateResultInEmptyTable(result);
        }
    }

    private void evaluateResultListInFullTable(List<Object> results) {
        this.evaluateResultInFullTable1(results);
    }

    private void evaluateResultInFullTable1(List<Object> results) {
        for (int j = 0; j < results.size(); ++j) {
            Object result = results.get(j);
            System.out.println("1 withResultListInTable.rowsCount():" + this.withResultListInTable.rowsCount());
            if (j >= this.withResultListInTable.rowsCount()) {
                this.addRowWithResult(result);
                continue;
            }
            List<Result> singleRow = this.withResultListInTable.getResultRow(j);
            for (int i = 0; i < this.withResultListInTable.colsCount(); ++i) {
                Class resType = this.withResultListInTable.getTableHeader().getColType(i);
                Object actual = null;
                Object expected = null;
                Result res = singleRow.get(i);
                if (resType.equals(ResultProperty.class)) {
                    actual = this.getFieldOfResult(result, res.getName());
                    expected = res.value();
                    this.evaluateResult(expected, actual, res.getOperator().getSymbol(), res, this.stepList);
                    continue;
                }
                actual = result;
                expected = result;
                this.evaluateResult(expected, actual, res.getOperator().getSymbol(), res, this.stepList);
            }
        }
    }

    private void evaluateEachRowAsAnExampleTable1(Object result, int index) {
        System.out.println("NOVA ERA 5:" + result + " ::" + index);
        List<Result> singleRow = this.withResultListInTable.getResultRow(index);
        System.out.println("NOVA ERA 6:" + result + " ::" + singleRow + "  \n::::" + this.withResultListInTable.resultColsCount());
        for (int i = 0; i < this.withResultListInTable.resultColsCount(); ++i) {
            try {
                Class resType = this.withResultListInTable.getTableHeader().getResultColTypes().get(i);
                System.out.println("NOVA ERA 7:" + resType);
                Object actual = null;
                Object expected = null;
                Result res = singleRow.get(i);
                if (resType.equals(ResultProperty.class)) {
                    actual = this.getFieldOfResult(result, res.getName());
                    expected = res.value();
                    this.evaluateResult(expected, actual, res.getOperator().getSymbol(), res, this.stepList);
                    continue;
                }
                actual = result;
                expected = result;
                this.evaluateResult(expected, actual, res.getOperator().getSymbol(), res, this.stepList);
                continue;
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
    }

    private void evaluateResultInEmptyTable(Object result) {
        this.addRowWithResult(result);
    }

    private void addRowWithResult(Object result) {
        ArrayList<Result> row = new ArrayList<Result>();
        ArrayList singleRow = new ArrayList();
        for (int i = 0; i < this.withResultListInTable.colsCount(); ++i) {
            Operator op;
            Class resType = this.withResultListInTable.getTableHeader().getColType(i);
            Object actual = null;
            Object expected = null;
            Result res = null;
            if (resType.equals(ResultProperty.class)) {
                res = new ResultProperty(this.withResultListInTable.getTableHeader().getColName(i), this.resultClass);
                op = new Operator(this.withResultListInTable.getTableHeader().getColOperator(i));
                res.setOperator(op);
                actual = this.getFieldOfResult(result, res.getName());
                op.setValue(actual);
                expected = actual;
                res.setSkipped();
                this.evaluateResult(expected, actual, res.getOperator().getSymbol(), res, this.stepList);
            } else {
                res = new Result(this.resultClass.getName(), this.resultClass);
                op = new Operator(this.withResultListInTable.getTableHeader().getColOperator(i));
                res.setOperator(op);
                actual = result;
                op.setValue(actual);
                expected = result;
                res.setSkipped();
                this.evaluateResult(expected, actual, res.getOperator().getSymbol(), res, this.stepList);
            }
            row.add(res);
        }
        this.withResultListInTable.addResultRow(row);
    }

    private void evaluateResultInFullTable(Object result) {
        for (List<Result> singleRow : this.withResultListInTable.getResultRows()) {
            for (int i = 0; i < this.withResultListInTable.colsCount(); ++i) {
                Class resType = this.withResultListInTable.getTableHeader().getColType(i);
                Object actual = null;
                Object expected = null;
                Result res = singleRow.get(i);
                if (resType.equals(ResultProperty.class)) {
                    actual = this.getFieldOfResult(result, res.getName());
                    expected = res.value();
                    this.evaluateResult(expected, actual, res.getOperator().getSymbol(), res, this.stepList);
                    continue;
                }
                actual = result;
                expected = result;
                this.evaluateResult(expected, actual, res.getOperator().getSymbol(), res, this.stepList);
            }
        }
    }

    public Object invokeExplosively(final Method method, final Object target, final Object ... params) {
        System.out.println("NOVA ERA 3:" + method + "    ;;  " + params[0]);
        if (method.isAnnotationPresent(Specification.class)) {
            try {
                return new ReflectiveCallable(){

                    @Override
                    protected Object runReflectiveCall() {
                        Object ret = null;
                        try {
                            ret = method.invoke(target, params);
                        }
                        catch (Throwable t) {
                            ret = t.getCause();
                        }
                        return ret;
                    }
                }.run();
            }
            catch (Throwable ex) {
                Logger.getLogger(ExampleEvaluator.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return null;
    }

    public void evaluate(Method method, Object target, ExampleBuilder eb) {
        Object result = null;
        System.out.println("NOVA ERA 0:" + this.withResultListInTable);
        if (this.withResultListInTable != null && this.withResultListInTable.isInOutTable()) {
            int i = 0;
            System.out.println("NOVA ERA 1");
            for (List<Param> lp : this.withResultListInTable.getInputRows()) {
                System.out.println("NOVA ERA 2:");
                Object[] params = new Object[lp.size()];
                for (int j = 0; j < params.length; ++j) {
                    params[j] = lp.get(j).value();
                }
                Object res = this.invokeExplosively(method, target, params);
                System.out.println("NOVA ERA 4:" + res);
                this.evaluateEachRowAsAnExampleTable1(res, i++);
            }
        } else {
            result = this.invokeExplosively(method, target, this.sb.getParams());
            if (this.withResultListInTable != null) {
                if (result instanceof List) {
                    if (!this.withResultListInTable.isInOutTable()) {
                        if (this.withResultListInTable.isEmpty()) {
                            this.evaluateResultListInEmptyTable((List)result);
                        } else {
                            this.evaluateResultListInFullTable((List)result);
                        }
                    }
                } else if (this.withResultListInTable.isEmpty()) {
                    this.evaluateResultInEmptyTable(result);
                } else {
                    this.evaluateResultInFullTable(result);
                }
            } else {
                this.evaluateResult(result);
            }
        }
        this.sm = Mangaba.getInstance().createScenarioModel(this.scenarioMethodName, this.sb.toString());
        for (StepModel stm : this.stepList) {
            this.sm.addStep(stm);
        }
        this.fm.addScenario(this.sm);
        if (!this.assertionErrors.isEmpty()) {
            StringBuilder buf = new StringBuilder("Scenario errors [");
            for (AssertionError a : this.assertionErrors) {
                buf.append("{").append(((Throwable)((Object)a)).getMessage()).append("},");
            }
            buf.append("]");
            Assert.fail((String)buf.toString());
        }
    }

    private Object getFieldOfResult(Object result, String fieldName) {
        try {
            Field field = this.resultClass.getDeclaredField(fieldName);
            field.setAccessible(true);
            Object fieldValue = field.get(result);
            return fieldValue;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException ex) {
            Logger.getLogger(ExampleBuilder.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    private void evaluateResult(Object expected, Object actual, String operator, Result res, List<StepModel> stepList) {
        String str = String.format("Actual result [%s] %s expected result [%s]", actual, operator, expected);
        StepModel stm = Mangaba.getInstance().createStepModell(str, 1);
        stepList.add(stm);
        long stepTime = System.currentTimeMillis();
        try {
            switch (res.getOperator().getOperatorSymbol()) {
                case EQUAL_TO: {
                    Assert.assertEquals((String)str, (Object)expected, (Object)actual);
                    break;
                }
                case NOT_EQUAL_TO: {
                    Assert.assertNotEquals((String)str, (Object)expected, (Object)actual);
                    break;
                }
                case LESS_THAN: {
                    if (expected instanceof Comparable && actual instanceof Comparable) {
                        Assert.assertTrue((String)str, (((Comparable)actual).compareTo(expected) < 0 ? 1 : 0) != 0);
                        break;
                    }
                    Assert.fail((String)"No comparable!");
                    break;
                }
                case GREATER_THAN: {
                    if (expected instanceof Comparable && actual instanceof Comparable) {
                        Assert.assertTrue((String)str, (((Comparable)actual).compareTo(expected) > 0 ? 1 : 0) != 0);
                        break;
                    }
                    Assert.fail((String)"No comparable!");
                    break;
                }
                case LESS_OR_EQUAL_TO: {
                    if (expected instanceof Comparable && actual instanceof Comparable) {
                        Assert.assertTrue((String)str, (((Comparable)actual).compareTo(expected) <= 0 ? 1 : 0) != 0);
                        break;
                    }
                    Assert.fail((String)"No comparable!");
                    break;
                }
                case GREATER_OR_EQUAL_TO: {
                    if (expected instanceof Comparable && actual instanceof Comparable) {
                        Assert.assertTrue((String)str, (((Comparable)actual).compareTo(expected) >= 0 ? 1 : 0) != 0);
                        break;
                    }
                    Assert.fail((String)"No comparable!");
                    break;
                }
                case EXCEPTION: {
                    Assert.assertEquals((String)str, expected.getClass(), actual.getClass());
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Invalid evaluate result to: " + str));
                }
            }
            stm.setDuration((int)(stepTime - System.currentTimeMillis()));
            if (!res.isSkipped()) {
                res.setPassed();
                stm.setPassed();
            } else {
                stm.setSkipped();
            }
        }
        catch (AssertionError error) {
            if (res != null) {
                res.setFailed();
            }
            stm.setFailed();
            stm.setDuration((int)(stepTime - System.currentTimeMillis()));
            String msgError = ((Throwable)((Object)error)).toString().replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
            stm.setResult(msgError);
            this.assertionErrors.add(error);
        }
    }

    public abstract class ReflectiveCallable {
        public Object run() throws Throwable {
            try {
                return this.runReflectiveCall();
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }

        protected abstract Object runReflectiveCall() throws Throwable;
    }
}

