/*
 * Decompiled with CFR 0.152.
 */
package x2br.mangaba.factories;

import java.util.HashMap;
import java.util.Map;
import x2br.mangaba.ParamFactory;

public class ParamFactories {
    private static final Map<String, ParamFactory> factoriesMap = new HashMap<String, ParamFactory>();

    public static void addFactory(String name, ParamFactory paramFactory) {
        factoriesMap.put(name, paramFactory);
    }

    public static <T> T getValue(Class<T> type, String value) {
        if (factoriesMap.containsKey(type.getSimpleName())) {
            return factoriesMap.get(type.getSimpleName()).getValue(value);
        }
        return null;
    }

    public static <T> T getValue(String factoryName, String value) {
        if (factoriesMap.containsKey(factoryName)) {
            return factoriesMap.get(factoryName).getValue(value);
        }
        return null;
    }

    static {
        factoriesMap.put("int", new IntFactory());
        factoriesMap.put("Integer", new IntFactory());
        factoriesMap.put("long", new LongFactory());
        factoriesMap.put("Long", new LongFactory());
        factoriesMap.put("float", new FloatFactory());
        factoriesMap.put("Float", new FloatFactory());
        factoriesMap.put("double", new DoubleFactory());
        factoriesMap.put("Double", new DoubleFactory());
        factoriesMap.put("byte", new ByteFactory());
        factoriesMap.put("Byte", new ByteFactory());
        factoriesMap.put("short", new ShortFactory());
        factoriesMap.put("Short", new ShortFactory());
        factoriesMap.put("boolean", new BooleanFactory());
        factoriesMap.put("Boolean", new BooleanFactory());
        factoriesMap.put("String", new StringFactory());
    }

    static class BooleanFactory
    implements ParamFactory<Boolean> {
        BooleanFactory() {
        }

        @Override
        public Boolean getValue(String value) {
            return Boolean.valueOf(value);
        }
    }

    static class ByteFactory
    implements ParamFactory<Byte> {
        ByteFactory() {
        }

        @Override
        public Byte getValue(String value) {
            return Byte.valueOf(value);
        }
    }

    static class ShortFactory
    implements ParamFactory<Short> {
        ShortFactory() {
        }

        @Override
        public Short getValue(String value) {
            return Short.valueOf(value);
        }
    }

    static class DoubleFactory
    implements ParamFactory<Double> {
        DoubleFactory() {
        }

        @Override
        public Double getValue(String value) {
            return Double.valueOf(value);
        }
    }

    static class FloatFactory
    implements ParamFactory<Float> {
        FloatFactory() {
        }

        @Override
        public Float getValue(String value) {
            return Float.valueOf(value);
        }
    }

    static class LongFactory
    implements ParamFactory<Long> {
        LongFactory() {
        }

        @Override
        public Long getValue(String value) {
            return Long.valueOf(value);
        }
    }

    static class IntFactory
    implements ParamFactory<Integer> {
        IntFactory() {
        }

        @Override
        public Integer getValue(String value) {
            return Integer.valueOf(value);
        }
    }

    static class StringFactory
    implements ParamFactory<String> {
        StringFactory() {
        }

        @Override
        public String getValue(String value) {
            return value;
        }
    }
}

