/*
 * Decompiled with CFR 0.152.
 */
package x2br.mangaba.listeners;

import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import x2br.mangaba.Mangaba;

public class MangabaListener
extends RunListener {
    private final boolean hasSummaryReport = Mangaba.getInstance().hasSuiteSummaryReportModel();
    private final Class testClassName;

    public MangabaListener(Class testClassName) {
        this.testClassName = testClassName;
    }

    public void testRunStarted(Description description) throws Exception {
        System.out.println("Number of tests to execute: " + description.testCount());
    }

    public void testRunFinished(Result result) throws Exception {
        System.out.println("Number of tests executed: " + result.getRunCount());
        Mangaba.getInstance().generateSpecificationReport(this.testClassName.getName());
        Mangaba.getInstance().clearSummaryReportModel(this.testClassName);
    }

    public void testStarted(Description description) throws Exception {
        System.out.println("Starting: " + description.getMethodName());
    }

    public void testFinished(Description description) throws Exception {
        System.out.println("Finished: " + description.getMethodName());
    }

    public void testFailure(Failure failure) throws Exception {
        System.out.println("Failed: " + failure.getDescription().getMethodName());
    }

    public void testAssumptionFailure(Failure failure) {
        System.out.println("testAssumptionFailure Failed: " + failure.getDescription().getMethodName());
    }

    public void testIgnored(Description description) throws Exception {
        System.out.println("Ignored: " + description.getMethodName());
    }
}

