/*
 * Decompiled with CFR 0.152.
 */
package x2br.mangaba.runners;

import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.TestClass;
import x2br.mangaba.runners.JUnitFactoryTest;
import x2br.mangaba.runners.JUnitFrameworkFactory;
import x2br.mangaba.runners.JUnitTestFactory;

public class JUnitFactoryRunner
extends BlockJUnit4ClassRunner {
    protected LinkedList<FrameworkMethod> tests = new LinkedList();

    public JUnitFactoryRunner(Class<?> cls) throws InitializationError {
        super(cls);
        try {
            this.computeTests();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void computeTests() throws Exception {
        this.tests.addAll(super.computeTestMethods());
        this.tests.addAll(this.computeFactoryTests());
    }

    protected Collection<? extends FrameworkMethod> computeFactoryTests() throws Exception {
        LinkedList<JUnitFrameworkFactory> tests = new LinkedList<JUnitFrameworkFactory>();
        for (FrameworkMethod method : this.getTestClass().getAnnotatedMethods(JUnitTestFactory.class)) {
            if (!Modifier.isStatic(method.getMethod().getModifiers())) {
                throw new InitializationError("Exception during initialization as method must be static.");
            }
            System.out.println("Metodo......................:" + method.getName());
            System.out.println("Metodo getMethod............:" + method.getMethod().getName());
            System.out.println("getTestClass................:" + this.getTestClass().getName());
            System.out.println("getTestClass javaClass......:" + this.getTestClass().getJavaClass());
            List<Object> instances = method.getMethod().invoke((Object)this.getTestClass().getJavaClass(), new Object[0]);
            if (instances.getClass().isArray()) {
                instances = Arrays.asList((Object[])instances);
            }
            if (!(instances instanceof Iterable)) {
                instances = Collections.singletonList(instances);
            }
            for (Object instance : (Iterable)instances) {
                for (FrameworkMethod m : new TestClass(instance.getClass()).getAnnotatedMethods(JUnitFactoryTest.class)) {
                    tests.add(new JUnitFrameworkFactory(m.getMethod(), instance, method.getName()));
                }
            }
        }
        return tests;
    }

    protected List<FrameworkMethod> computeTestMethods() {
        return this.tests;
    }

    protected void validateInstanceMethods(List<Throwable> errors) {
        this.validatePublicVoidNoArgMethods(After.class, false, errors);
        this.validatePublicVoidNoArgMethods(Before.class, false, errors);
        this.validatePublicVoidNoArgMethods(BeforeClass.class, true, errors);
        this.validateTestMethods(errors);
    }
}

