/*
 * Decompiled with CFR 0.152.
 */
package x2br.mangaba.runners;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import org.junit.runners.model.FrameworkMethod;
import x2br.mangaba.Mangaba;
import x2br.mangaba.annotations.Specification;
import x2br.mangaba.builders.ExampleBuilder;
import x2br.mangaba.builders.ExampleEvaluator;
import x2br.mangaba.template.model.UnitTestModel;

public class MangabaFrameworkMethod
extends FrameworkMethod {
    private final String targetName;
    private final ExampleBuilder sb;
    private ExampleEvaluator se;

    public MangabaFrameworkMethod(Method method, String targetName, ExampleBuilder sb) {
        super(method);
        this.targetName = targetName;
        this.sb = sb;
        if (null != sb) {
            this.se = new ExampleEvaluator(sb);
        }
    }

    public Object invokeExplosively(Object target, Object ... params) throws Throwable {
        if (this.getMethod().isAnnotationPresent(Specification.class)) {
            this.se.evaluate(this.getMethod(), target, this.sb);
            return null;
        }
        long testTime = System.currentTimeMillis();
        try {
            Object ret = super.invokeExplosively(target, params);
            UnitTestModel utm = Mangaba.getInstance().createUnitTestModell(target.getClass().getName(), this.getName(), (int)(System.currentTimeMillis() - testTime), true);
            if (Mangaba.getInstance().hasSuiteSummaryReportModel()) {
                Mangaba.getInstance().getSuiteSummaryReportModel().addUnitTest(utm);
            }
            utm.setResult(ret);
            Mangaba.getInstance().getSummaryReportModel(target.getClass()).addUnitTest(utm);
            return ret;
        }
        catch (Throwable t) {
            String error = this.getStringFromException(t);
            UnitTestModel utm = Mangaba.getInstance().createUnitTestModell(target.getClass().getName(), this.getName(), (int)(System.currentTimeMillis() - testTime), false);
            utm.setResult(t);
            utm.setError(error);
            if (Mangaba.getInstance().hasSuiteSummaryReportModel()) {
                Mangaba.getInstance().getSuiteSummaryReportModel().addUnitTest(utm);
            }
            Mangaba.getInstance().getSummaryReportModel(this.getDeclaringClass()).addUnitTest(utm);
            throw t;
        }
    }

    public String getStringFromException(Throwable ex) {
        StringWriter errors = new StringWriter();
        ex.printStackTrace(new PrintWriter(errors));
        return errors.toString();
    }

    public String getName() {
        if (null != this.targetName) {
            return String.format("%s.%s", this.targetName, this.getMethod().getName());
        }
        return super.getName();
    }

    public boolean equals(Object obj) {
        if (!MangabaFrameworkMethod.class.isInstance(obj)) {
            return false;
        }
        if (null != this.targetName) {
            return ((MangabaFrameworkMethod)((Object)obj)).getMethod().equals(this.getMethod()) && ((MangabaFrameworkMethod)((Object)obj)).targetName.equals(this.targetName);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        if (null != this.targetName) {
            return super.hashCode() + this.targetName.hashCode();
        }
        return super.hashCode();
    }
}

