/*
 * Decompiled with CFR 0.152.
 */
package x2br.mangaba.runners;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import x2br.mangaba.Mangaba;
import x2br.mangaba.annotations.Example;
import x2br.mangaba.annotations.Specification;
import x2br.mangaba.builders.ExampleBuilder;
import x2br.mangaba.listeners.MangabaListener;
import x2br.mangaba.runners.MangabaFrameworkMethod;
import x2br.mangaba.template.model.FeatureModel;

public class MangabaRunner
extends BlockJUnit4ClassRunner {
    protected LinkedList<FrameworkMethod> tests = new LinkedList();
    private MangabaListener mangabaListener;
    private Mangaba mangaba = Mangaba.getInstance();
    private FeatureModel featureModel = null;

    public MangabaRunner(Class<?> cls) throws InitializationError {
        super(cls);
        this.mangabaListener = new MangabaListener(cls);
        this.computeTests();
    }

    public void run(RunNotifier notifier) {
        notifier.addListener((RunListener)this.mangabaListener);
        super.run(notifier);
    }

    protected void computeTests() throws InitializationError {
        for (FrameworkMethod fm : super.computeTestMethods()) {
            this.tests.add(new MangabaFrameworkMethod(fm.getMethod(), null, null));
        }
        this.computeFeatureTests();
    }

    protected void computeFeatureTests() throws InitializationError {
        FrameworkMethod featureMethod = null;
        Iterator iterator = this.getTestClass().getAnnotatedMethods(Specification.class).iterator();
        if (iterator.hasNext()) {
            FrameworkMethod method = (FrameworkMethod)iterator.next();
            Specification feature = (Specification)method.getAnnotation(Specification.class);
            this.featureModel = this.mangaba.createFeatureModel(feature.name(), method.getName(), feature.acceptanceCriteria());
            featureMethod = method;
        }
        for (FrameworkMethod method : this.getTestClass().getAnnotatedMethods(Example.class)) {
            ExampleBuilder sb = null;
            Example templateScenario = (Example)method.getAnnotation(Example.class);
            Object instance = null;
            if (!Modifier.isStatic(method.getMethod().getModifiers())) {
                System.out.println("Exception during initialization as method " + method.getName() + " must be static.");
                throw new InitializationError("Exception during initialization as method " + method.getName() + " must be static.");
            }
            if (method.getMethod().getReturnType() != ExampleBuilder.class) {
                System.out.println("Exception during initialization as method " + method.getName() + " return type should be ExampleBuilder");
                throw new InitializationError("Exception during initialization as method " + method.getName() + " return type should be ExampleBuilder");
            }
            if (method.getMethod().getParameterTypes().length != 1) {
                System.out.println("Exception during initialization as method " + method.getName() + " should have one parameter ExampleBuilder type.");
                throw new InitializationError("Exception during initialization as method " + method.getName() + " should have one parameter ExampleBuilder type.");
            }
            if (method.getMethod().getParameterTypes().length == 1 && method.getMethod().getParameterTypes()[0] != ExampleBuilder.class) {
                System.out.println("Exception during initialization as method " + method.getName() + " parameter should have ExampleBuilder type.");
                throw new InitializationError("Exception during initialization as method " + method.getName() + " parameter should have ExampleBuilder type.");
            }
            if (method.getMethod().getReturnType() != ExampleBuilder.class) {
                System.out.println("Exception during initialization as method " + method.getName() + " return type should be ExampleBuilder");
                throw new InitializationError("Exception during initialization as method " + method.getName() + " return type should be ExampleBuilder");
            }
            this.mangaba.getSummaryReportModel(this.getTestClass().getJavaClass()).addFeature(this.featureModel);
            if (this.mangaba.hasSuiteSummaryReportModel()) {
                System.out.println("\n****** Add a feature na SUITE!!!\n");
                this.mangaba.getSuiteSummaryReportModel().addFeature(this.featureModel);
            }
            sb = new ExampleBuilder(this.getTestClass().getJavaClass(), method.getName(), this.featureModel);
            try {
                instance = method.getMethod().invoke((Object)this.getTestClass().getJavaClass(), sb);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                Logger.getLogger(MangabaRunner.class.getName()).log(Level.SEVERE, null, ex);
                throw new InitializationError((Throwable)ex);
            }
            this.tests.add(new MangabaFrameworkMethod(featureMethod.getMethod(), method.getName(), sb));
        }
    }

    protected List<FrameworkMethod> computeTestMethods() {
        return this.tests;
    }

    protected void validateInstanceMethods(List<Throwable> errors) {
        this.validatePublicVoidNoArgMethods(After.class, false, errors);
        this.validatePublicVoidNoArgMethods(Before.class, false, errors);
        this.validatePublicVoidNoArgMethods(BeforeClass.class, true, errors);
        this.validateTestMethods(errors);
    }
}

