/*
 * Decompiled with CFR 0.152.
 */
package x2br.mangaba.template.engine;

import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import x2br.mangaba.template.TemplateException;
import x2br.mangaba.template.engine.MyLog;

public class VelocityHandler {
    private static VelocityEngine ve;
    private static Map<String, Template> templateCache;
    private static final Logger log;
    public static final String LOGGER_NAME;

    private static Template loadTemplate(String templateName) {
        Template template = null;
        if (templateCache.containsKey(templateName)) {
            template = templateCache.get(templateName);
        } else {
            try {
                template = ve.getTemplate(templateName);
                templateCache.put(templateName, template);
            }
            catch (ParseErrorException ex) {
                Logger.getLogger(VelocityHandler.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (Exception ex) {
                Logger.getLogger(VelocityHandler.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return template;
    }

    public static String executeTemplate(String templateContent, Map<?, ?> params) throws TemplateException {
        try {
            StringWriter writer = new StringWriter();
            VelocityContext context = new VelocityContext(params);
            ve.evaluate((Context)context, (Writer)writer, "executeTemplate", templateContent);
            return writer.getBuffer().toString().trim();
        }
        catch (ResourceNotFoundException e) {
            throw new TemplateException("Recurso n\u00e3o encontrado!", e.getCause());
        }
        catch (ParseErrorException e) {
            throw new TemplateException("Erro no parser do template!", e.getCause());
        }
        catch (MethodInvocationException e) {
            throw new TemplateException("", e.getCause());
        }
        catch (Exception e) {
            throw new TemplateException("", e.getCause());
        }
    }

    public static String execute(String fileTemplateName, Map<?, ?> params) throws TemplateException {
        try {
            Template tp = VelocityHandler.loadTemplate(fileTemplateName);
            StringWriter writer = new StringWriter();
            VelocityContext context = new VelocityContext(params);
            tp.merge((Context)context, (Writer)writer);
            return writer.getBuffer().toString().trim();
        }
        catch (ResourceNotFoundException e) {
            throw new TemplateException("Recurso n\u00e3o encontrado!", e.getCause());
        }
        catch (ParseErrorException e) {
            throw new TemplateException("Erro no parser do template!", e.getCause());
        }
        catch (MethodInvocationException e) {
            throw new TemplateException("", e.getCause());
        }
        catch (Exception e) {
            throw new TemplateException("", e.getCause());
        }
    }

    public static String execute(String fileTemplateName, String templateTag, Map<?, ?> params) throws TemplateException {
        try {
            Template tp = VelocityHandler.loadTemplate(fileTemplateName);
            StringWriter writer = new StringWriter();
            VelocityContext context = new VelocityContext(params);
            tp.merge((Context)context, (Writer)writer);
            ve.evaluate((Context)context, (Writer)writer, fileTemplateName.concat(".").concat(templateTag), "$".concat(templateTag));
            return writer.getBuffer().toString().trim();
        }
        catch (ResourceNotFoundException e) {
            throw new TemplateException("Recurso n\u00e3o encontrado!", e.getCause());
        }
        catch (ParseErrorException e) {
            throw new TemplateException("Erro no parser do template!", e.getCause());
        }
        catch (MethodInvocationException e) {
            throw new TemplateException("", e.getCause());
        }
        catch (Exception e) {
            throw new TemplateException("", e.getCause());
        }
    }

    public static void main(String[] args) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("nome", "Marc\u00e3o");
        System.out.println("==>" + VelocityHandler.execute("templates/sql/PessoaJuridica.vsl", "$findByNmPessoaJuridica", map));
        System.out.println("==>" + VelocityHandler.executeTemplate("Meu apelido \u00e9 $nome.", map));
    }

    static {
        log = Logger.getLogger(VelocityHandler.class.getName());
        LOGGER_NAME = VelocityHandler.class.getName();
        try {
            templateCache = new HashMap<String, Template>();
            ve = new VelocityEngine();
            ve.setProperty("runtime.log.logsystem", (Object)new MyLog());
            ve.setProperty("input.encoding", (Object)"UTF-8");
            ve.setProperty("output.encoding", (Object)"UTF-8");
            ve.setProperty("resource.loader", (Object)"classpath");
            ve.setProperty("classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
            ve.init();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, null, ex);
        }
    }
}

