/*
 * Decompiled with CFR 0.152.
 */
package x2br.mangaba.template.model;

import java.util.ArrayList;
import java.util.List;
import x2br.mangaba.template.model.ScenarioModel;

public class FeatureModel {
    private final int id;
    private final String methodName;
    private final String name;
    private final String description;
    private int passedScenarios = 0;
    private int failedScenarios = 0;
    private int skippedScenarios = 0;
    private int pendingScenarios = 0;
    private final List<ScenarioModel> scenarios;

    public FeatureModel(int id, String name, String methodName, String description) {
        this.id = id;
        this.name = name;
        this.methodName = methodName;
        this.description = description;
        this.scenarios = new ArrayList<ScenarioModel>();
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void process() {
        this.passedScenarios = 0;
        this.failedScenarios = 0;
        for (ScenarioModel sc : this.scenarios) {
            sc.process();
            if (sc.isPassed()) {
                ++this.passedScenarios;
                continue;
            }
            ++this.failedScenarios;
        }
        System.out.println("FEATURE " + this.name + ": passed=" + this.passedScenarios + "  failed:" + this.failedScenarios);
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getDescription() {
        return this.description;
    }

    public List<ScenarioModel> getScenarios() {
        return this.scenarios;
    }

    public void addScenario(ScenarioModel scenario) {
        this.scenarios.add(scenario);
    }

    public int getPassedScenarios() {
        return this.passedScenarios;
    }

    public void setPassedScenarios(int passedScenarios) {
        this.passedScenarios = passedScenarios;
    }

    public int getFailedScenarios() {
        return this.failedScenarios;
    }

    public void setFailedScenarios(int failedScenarios) {
        this.failedScenarios = failedScenarios;
    }

    public int getSkippedScenarios() {
        return this.skippedScenarios;
    }

    public void setSkippedScenarios(int skippedScenarios) {
        this.skippedScenarios = skippedScenarios;
    }

    public int getPendingScenarios() {
        return this.pendingScenarios;
    }

    public void setPendingScenarios(int pendingScenarios) {
        this.pendingScenarios = pendingScenarios;
    }

    public boolean isPassed() {
        return this.failedScenarios == 0;
    }
}

