/*
 * Decompiled with CFR 0.152.
 */
package x2br.mangaba.template.model;

import java.util.ArrayList;
import java.util.List;
import x2br.mangaba.template.model.StepModel;

public class ScenarioModel {
    private int id;
    private String description;
    private List<StepModel> steps;
    private int passed = 0;
    private int failed = 0;
    private int skipped = 0;
    private int pending = 0;
    private final String name;

    public ScenarioModel(int id, String scenarioName, String description) {
        this.id = id;
        this.description = description;
        this.name = scenarioName;
        this.steps = new ArrayList<StepModel>();
    }

    public void process() {
        this.passed = 0;
        this.failed = 0;
        for (StepModel st : this.steps) {
            if (st.isPassed()) {
                ++this.passed;
                continue;
            }
            if (st.isFailed()) {
                ++this.failed;
                continue;
            }
            if (st.isSkipped()) {
                ++this.skipped;
                continue;
            }
            if (!st.isPending()) continue;
            ++this.pending;
        }
    }

    public String getName() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<StepModel> getSteps() {
        return this.steps;
    }

    public void addStep(StepModel step) {
        this.steps.add(step);
    }

    public void setSteps(List<StepModel> steps) {
        this.steps = steps;
    }

    public int getPassed() {
        return this.passed;
    }

    public void setPassed(int passed) {
        this.passed = passed;
    }

    public int getFailed() {
        return this.failed;
    }

    public void setFailed(int failed) {
        this.failed = failed;
    }

    public int getSkipped() {
        return this.skipped;
    }

    public void setSkipped(int skipped) {
        this.skipped = skipped;
    }

    public int getPending() {
        return this.pending;
    }

    public void setPending(int pending) {
        this.pending = pending;
    }

    public boolean isPassed() {
        return this.failed == 0;
    }

    public String toString() {
        return "ScenarioModel{id=" + this.id + ", description=" + this.description + '}';
    }
}

