/*
 * Decompiled with CFR 0.152.
 */
package x2br.mangaba.template.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import x2br.mangaba.template.model.FeatureModel;
import x2br.mangaba.template.model.ScenarioModel;
import x2br.mangaba.template.model.UnitTestModel;

public class SummaryReportModel {
    private int id;
    private Date date;
    private String appName;
    private String appVersion;
    private Map<Integer, FeatureModel> featuresMap;
    private List<FeatureModel> features;
    private final List<UnitTestModel> unitTests;
    private int passedFeatures = 0;
    private int failedFeatures = 0;
    private int passedScenarios = 0;
    private int failedScenarios = 0;
    private int skippedScenarios = 0;
    private int pendingScenarios = 0;
    private int passedUnitTests = 0;
    private int failedUnitTests = 0;
    private int skippedUnitTests = 0;
    private int pendingUnitTests = 0;
    private final String testClassName;

    public SummaryReportModel(int id, Date date, String appName, String appVersion, String testClassName) {
        this.id = id;
        this.date = date;
        this.appName = appName;
        this.appVersion = appVersion;
        this.featuresMap = new HashMap<Integer, FeatureModel>();
        this.features = new ArrayList<FeatureModel>();
        this.unitTests = new ArrayList<UnitTestModel>();
        this.testClassName = testClassName;
    }

    public String getTestClassName() {
        return this.testClassName;
    }

    public void process() {
        this.passedFeatures = 0;
        this.failedFeatures = 0;
        for (FeatureModel fm : this.features) {
            fm.process();
            if (fm.isPassed()) {
                ++this.passedFeatures;
            } else {
                ++this.failedFeatures;
            }
            for (ScenarioModel sm : fm.getScenarios()) {
                if (sm.isPassed()) {
                    ++this.passedScenarios;
                    continue;
                }
                ++this.failedScenarios;
            }
        }
        this.skippedUnitTests = 0;
        this.pendingUnitTests = 0;
        for (UnitTestModel utm : this.unitTests) {
            if (utm.isPassed()) {
                ++this.passedUnitTests;
                continue;
            }
            ++this.failedUnitTests;
        }
    }

    public int getId() {
        return this.id;
    }

    public Date getDate() {
        return this.date;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    public List<FeatureModel> getFeatures() {
        return this.features;
    }

    public void addFeature(FeatureModel feature) {
        if (!this.featuresMap.containsKey(feature.getId())) {
            this.features.add(feature);
        }
        this.featuresMap.put(feature.getId(), feature);
    }

    public FeatureModel getFeatureById(Integer id) {
        return this.featuresMap.get(id);
    }

    public int getPassedFeatures() {
        return this.passedFeatures;
    }

    public void setPassedFeatures(int passedFeatures) {
        this.passedFeatures = passedFeatures;
    }

    public int getFailedFeatures() {
        return this.failedFeatures;
    }

    public void setFailedFeatures(int failedFeatures) {
        this.failedFeatures = failedFeatures;
    }

    public int getPassedScenarios() {
        return this.passedScenarios;
    }

    public void setPassedScenarios(int passedScenarios) {
        this.passedScenarios = passedScenarios;
    }

    public int getFailedScenarios() {
        return this.failedScenarios;
    }

    public void setFailedScenarios(int failedScenarios) {
        this.failedScenarios = failedScenarios;
    }

    public int getSkippedScenarios() {
        return this.skippedScenarios;
    }

    public void setSkippedScenarios(int skippedScenarios) {
        this.skippedScenarios = skippedScenarios;
    }

    public int getPendingScenarios() {
        return this.pendingScenarios;
    }

    public void setPendingScenarios(int pendingScenarios) {
        this.pendingScenarios = pendingScenarios;
    }

    public int getPassedUnitTests() {
        return this.passedUnitTests;
    }

    public int getFailedUnitTests() {
        return this.failedUnitTests;
    }

    public int getSkippedUnitTests() {
        return this.skippedUnitTests;
    }

    public int getPendingUnitTests() {
        return this.pendingUnitTests;
    }

    public void addUnitTest(UnitTestModel unitTest) {
        this.unitTests.add(unitTest);
    }

    public List<UnitTestModel> getUnitTests() {
        return this.unitTests;
    }
}

