/*
 * Decompiled with CFR 0.152.
 */
package x2br.mangaba.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.logging.Level;
import java.util.logging.Logger;
import x2br.mangaba.builders.ExampleBuilder;

public class MangabaUtil {
    private static final String PROPERTY_OUTPUT_DIR = "mangaba.output.dir";

    public static File getBaseOutputDir() {
        return MangabaUtil.getBaseOutputDir("");
    }

    public static File getBaseOutputDir(String folder) {
        String outputPath;
        if (folder == null) {
            folder = "";
        }
        outputPath = (outputPath = System.getProperty(PROPERTY_OUTPUT_DIR)) != null ? outputPath.concat(File.separator).concat(folder) : "target".concat(File.separator).concat("mangaba").concat(File.separator).concat(folder);
        File baseOutputDir = new File(outputPath);
        return baseOutputDir;
    }

    public static void write(String folder, String fileName, String str) throws IOException {
        File path = MangabaUtil.getBaseOutputDir(folder);
        if (!path.exists()) {
            path.mkdirs();
        }
        System.out.println("PATH:" + path.getAbsolutePath());
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(path.getAbsolutePath().concat(File.separator).concat(fileName)));){
            bw.write(str);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String capitalize(String str) {
        return Character.toUpperCase(str.charAt(0)) + str.substring(1);
    }

    public static String[] splitCamelCaseString(String str) {
        return MangabaUtil.spliFromCamelCase(str, false);
    }

    public static String[] spliFromCamelCase(String str, boolean capitalizeAll) {
        if (null != str) {
            String[] split = str.split("(?<!(^|[A-Z]))(?=[A-Z])|(?<!^)(?=[A-Z][a-z])");
            if (capitalizeAll) {
                split[0] = MangabaUtil.capitalize(split[0]);
            }
            return split;
        }
        return null;
    }

    public static String toTitleCase(String camelCaseString) {
        String[] spli = MangabaUtil.spliFromCamelCase(camelCaseString, true);
        return MangabaUtil.join(spli, " ");
    }

    public static String join(String[] parts, String separator) {
        StringBuilder sb = new StringBuilder();
        if (parts.length > 0) {
            sb.append(parts[0]);
            for (int i = 1; i < parts.length; ++i) {
                sb.append(separator).append(parts[i]);
            }
        }
        return sb.toString();
    }

    public static Class getFieldType(Class clazz, String fieldName) {
        try {
            Field field = clazz.getDeclaredField(fieldName);
            return field.getType();
        }
        catch (NoSuchFieldException | SecurityException ex) {
            Logger.getLogger(ExampleBuilder.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }
}

