/*
 * Decompiled with CFR 0.152.
 */
package x2br.mangaba.util;

public class TesteCamelCase {
    public static String join(String[] parts, String separator) {
        StringBuilder sb = new StringBuilder();
        if (parts.length > 0) {
            sb.append(parts[0]);
            for (int i = 1; i < parts.length; ++i) {
                sb.append(separator).append(parts[i]);
            }
        }
        return sb.toString();
    }

    public static String join(String[] parts) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < parts.length; ++i) {
            sb.append(parts[i]);
        }
        return sb.toString();
    }

    public static String toCamelCase(String strData, boolean keepBlanks) {
        String[] parts = strData.split("\\s+");
        for (int i = 0; i < parts.length; ++i) {
            parts[i] = parts[i].length() > 1 ? Character.toUpperCase(parts[i].charAt(0)) + parts[i].substring(1).toLowerCase() : parts[i].toUpperCase();
        }
        if (keepBlanks) {
            return TesteCamelCase.join(parts, " ");
        }
        return TesteCamelCase.join(parts);
    }

    public static String toTitleCase(String input) {
        StringBuilder titleCase = new StringBuilder();
        boolean nextTitleCase = true;
        for (char c : input.toCharArray()) {
            if (Character.isSpaceChar(c)) {
                nextTitleCase = true;
            } else if (nextTitleCase) {
                c = Character.toTitleCase(c);
                nextTitleCase = false;
            }
            titleCase.append(c);
        }
        return titleCase.toString();
    }

    public static String capitalize(String str) {
        return Character.toUpperCase(str.charAt(0)) + str.substring(1);
    }

    public static String[] splitCamelCaseString(String str) {
        return TesteCamelCase.spliFromCamelCase(str, false);
    }

    public static String[] spliFromCamelCase(String str, boolean capitalizeAll) {
        if (null != str) {
            return str.split("(?<!(^|[A-Z]))(?=[A-Z])|(?<!^)(?=[A-Z][a-z])");
        }
        return null;
    }

    String camelCase(String str) {
        StringBuilder builder = new StringBuilder(str);
        boolean isLastSpace = true;
        for (int i = 0; i < builder.length(); ++i) {
            char ch = builder.charAt(i);
            if (isLastSpace && ch >= 'a' && ch <= 'z') {
                builder.setCharAt(i, (char)(ch + -32));
                isLastSpace = false;
                continue;
            }
            isLastSpace = ch == ' ';
        }
        return builder.toString();
    }

    public static void main(String[] args) {
        System.out.println(TesteCamelCase.toCamelCase("O TESTE DE FUNCIONAMENTO de CAMEL CASE", false));
        System.out.println(TesteCamelCase.toCamelCase("TestaNdo o CamEl cASE", true));
        for (String w : "eclipseRCPExtJBCDemais".split("(?<!(^|[A-Z]))(?=[A-Z])|(?<!^)(?=[A-Z][a-z])")) {
            System.out.println(w);
        }
    }
}

