/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.catalog.entities;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xbib.catalog.entities.ClassifierEntry;

public class Classifier {
    private String classifierID;
    private Map<String, Collection<ClassifierEntry>> map;
    private Function<String, ClassifierEntry> mapToKeyValue = line -> {
        String[] p = line.split("\t");
        return p.length > 2 ? new ClassifierEntry(this.classifierID + p[0].trim(), p[1].trim(), p[2].trim()) : null;
    };

    public Classifier load(InputStream in, String name, String classifierID) throws IOException {
        return this.load(new InputStreamReader(in, StandardCharsets.UTF_8), name, classifierID);
    }

    public Classifier load(Reader reader, String name, String classifierID) throws IOException {
        this.map = new HashMap<String, Collection<ClassifierEntry>>();
        this.classifierID = classifierID;
        try (BufferedReader bufferedReader = new BufferedReader(reader);){
            bufferedReader.lines().map(this.mapToKeyValue).filter(Objects::nonNull).forEach(kv -> this.putEntry(this.map, name, (ClassifierEntry)kv));
        }
        return this;
    }

    private void putEntry(Map<String, Collection<ClassifierEntry>> map, String name, ClassifierEntry classifierEntry) {
        String key = name + '.' + classifierEntry.doc + '.';
        Collection<Object> entries = map.containsKey(key) ? map.get(key) : new LinkedList();
        entries.add(classifierEntry);
        map.put(key, entries);
        map.put(name + '.' + classifierEntry.doc + '.' + classifierEntry.code, entries);
    }

    public Map<String, Collection<ClassifierEntry>> getMap() {
        return this.map;
    }

    public Collection<ClassifierEntry> lookup(String key) {
        return this.map.get(key);
    }

    public Collection<ClassifierEntry> lookup(String name, String doc, String code, Pattern pattern) {
        Collection<ClassifierEntry> entries;
        if (code == null || code.isEmpty() || code.trim().isEmpty()) {
            return null;
        }
        String k = name + '.' + doc + '.' + code;
        Collection<ClassifierEntry> collection = entries = this.map.containsKey(k) ? this.map.get(k) : null;
        if (entries != null) {
            return entries;
        }
        if (pattern == null) {
            String[] array;
            for (String s : array = code.split("\\s+")) {
                if (s.length() <= 0 || code.equals(s) || (entries = this.lookup(name, doc, s, null)) == null) continue;
                return entries;
            }
            return null;
        }
        Matcher m = pattern.matcher(code);
        if (m.find() && (entries = this.lookup(name, doc, code.substring(m.start(), m.end()), null)) != null) {
            return entries;
        }
        return null;
    }
}

