/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.catalog.entities.mab;

import java.io.IOException;
import java.util.Map;
import org.xbib.catalog.entities.CatalogEntity;
import org.xbib.catalog.entities.CatalogEntityWorker;
import org.xbib.catalog.entities.CatalogEntityWorkerState;
import org.xbib.catalog.entities.TermFacet;
import org.xbib.content.rdf.Literal;
import org.xbib.marc.MarcField;

public class FormatCarrierSimplified
extends CatalogEntity {
    public static final String FACET = "dc.format";
    private String predicate = this.getClass().getSimpleName();

    public FormatCarrierSimplified(Map<String, Object> params) {
        super(params);
        if (params.containsKey("_predicate")) {
            this.predicate = params.get("_predicate").toString();
        }
    }

    @Override
    public CatalogEntity transform(CatalogEntityWorker worker, MarcField field) throws IOException {
        Map codes = (Map)this.getParams().get("codes");
        if (codes == null) {
            return super.transform(worker, field);
        }
        Map facetcodes = (Map)this.getParams().get("facetcodes");
        if (facetcodes == null) {
            return super.transform(worker, field);
        }
        for (MarcField.Subfield subfield : field.getSubfields()) {
            String value = subfield.getValue();
            for (int i = 0; i < value.length(); ++i) {
                String code = (String)codes.get(value.substring(i, i + 1));
                if (code == null && i + 1 < value.length()) {
                    code = (String)codes.get(value.substring(i, i + 2));
                }
                worker.getWorkerState().getResource().add(this.predicate, code);
                code = (String)facetcodes.get(value.substring(i, i + 1));
                if (code == null && i + 1 < value.length()) {
                    code = (String)facetcodes.get(value.substring(i, i + 2));
                }
                this.facetize(worker.getWorkerState(), code);
            }
        }
        return super.transform(worker, field);
    }

    private void facetize(CatalogEntityWorkerState state, String value) {
        state.getFacets().putIfAbsent(FACET, new TermFacet().setName(FACET).setType(Literal.STRING));
        state.getFacets().get(FACET).addValue(value);
    }
}

