/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.catalog.entities.mab;

import java.io.IOException;
import java.util.Map;
import org.xbib.catalog.entities.CatalogEntity;
import org.xbib.catalog.entities.CatalogEntityWorker;
import org.xbib.marc.MarcField;

public class TypeMonographSimplified
extends CatalogEntity {
    private static final String FACET_NAME = "dc.type";
    private String predicate = this.getClass().getSimpleName();
    private Map<String, Object> codes;
    private Map<String, Object> facetcodes;

    public TypeMonographSimplified(Map<String, Object> params) {
        super(params);
        if (params.containsKey("_predicate")) {
            this.predicate = params.get("_predicate").toString();
        }
        this.codes = this.getCodes();
        this.facetcodes = this.getFacetCodes();
    }

    @Override
    public CatalogEntity transform(CatalogEntityWorker worker, MarcField field) throws IOException {
        String code;
        int i;
        String value = this.getValue(field);
        if (this.codes != null) {
            for (i = 0; i < value.length(); ++i) {
                code = (String)this.codes.get(value.substring(i, i + 1));
                if (code == null && i + 1 < value.length()) {
                    code = (String)this.codes.get(value.substring(i, i + 2));
                }
                worker.getWorkerState().getResource().add(this.predicate, code);
            }
        }
        if (this.facetcodes != null) {
            for (i = 0; i < value.length(); ++i) {
                code = (String)this.facetcodes.get(value.substring(i, i + 1));
                if (code == null && i + 1 < value.length()) {
                    code = (String)this.facetcodes.get(value.substring(i, i + 2));
                }
                this.facetize(worker, code);
            }
        }
        return null;
    }

    @Override
    protected String getFacetName() {
        return FACET_NAME;
    }
}

