/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.catalog.entities.marc.zdb.hol;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xbib.catalog.entities.CatalogEntity;
import org.xbib.catalog.entities.CatalogEntityWorker;
import org.xbib.marc.MarcField;

public class PhysicalDescriptionCode
extends CatalogEntity {
    private static final Logger logger = Logger.getLogger(PhysicalDescriptionCode.class.getName());

    public PhysicalDescriptionCode(Map<String, Object> params) {
        super(params);
    }

    @Override
    public CatalogEntity transform(CatalogEntityWorker worker, MarcField field) throws IOException {
        String value = this.getValue(field);
        Map codes = (Map)this.getParams().get("codes");
        if (codes == null) {
            logger.log(Level.WARNING, MessageFormat.format("no 'codes' for {0}", value));
            return super.transform(worker, field);
        }
        codes = (Map)codes.get("0");
        if (value != null) {
            this.check(worker, codes, value);
        }
        for (MarcField.Subfield subfield : field.getSubfields()) {
            this.check(worker, codes, subfield.getValue());
        }
        return super.transform(worker, field);
    }

    private void check(CatalogEntityWorker worker, Map<String, Object> codes, String data) throws IOException {
        Map m = (Map)codes.get(data.substring(0, 1));
        if (m == null) {
            return;
        }
        String predicate = (String)m.get("_predicate");
        for (int i = 1; i < data.length(); ++i) {
            String ch = data.substring(i, i + 1);
            Map q = (Map)m.get(Integer.toString(i));
            if (q == null) continue;
            String code = (String)q.get(ch);
            worker.getWorkerState().getResource().add(predicate, code);
        }
    }
}

