/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.catalog.entities.matching.title;

import java.text.Normalizer;
import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.LinkedList;
import org.xbib.catalog.entities.matching.Domain;
import org.xbib.catalog.entities.matching.Key;
import org.xbib.catalog.entities.matching.string.EncoderException;
import org.xbib.catalog.entities.matching.string.SimpleEntropyEncoder;

public class TitleKey
extends AbstractCollection<String>
implements Key<String> {
    private final LinkedList<String> list = new LinkedList();
    private final SimpleEntropyEncoder enc = new SimpleEntropyEncoder();
    private char delimiter = (char)47;

    @Override
    public Domain getDomain() {
        return Domain.TITLE;
    }

    @Override
    public void setDelimiter(char delimiter) {
        this.delimiter = delimiter;
    }

    @Override
    public char getDelimiter() {
        return this.delimiter;
    }

    @Override
    public boolean isUsable() {
        return !this.isEmpty();
    }

    @Override
    public Iterator<String> iterator() {
        return this.list.iterator();
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean add(String value) {
        String normalized = this.normalize(value);
        int n = this.size();
        return n <= 5 && (normalized.length() >= 4 || n <= 1) && this.list.add(normalized);
    }

    @Override
    public String encode() throws EncoderException {
        StringBuilder sb = new StringBuilder();
        for (String s : this) {
            sb.append(this.enc.encode(s)).append(this.delimiter);
        }
        int len = sb.length();
        if (len > 0) {
            sb.deleteCharAt(len - 1);
        }
        return sb.toString();
    }

    protected String normalize(String value) {
        String s = value.replaceAll("\\[.+\\]", "");
        s = Normalizer.normalize(s, Normalizer.Form.NFKD);
        return s.replaceAll("[^\\p{L}\\p{N}]", "");
    }
}

