/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.catalog.entities;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.xbib.catalog.entities.CatalogEntityWorker;
import org.xbib.catalog.entities.CatalogEntityWorkerState;
import org.xbib.catalog.entities.TermFacet;
import org.xbib.content.rdf.Literal;
import org.xbib.content.rdf.Resource;
import org.xbib.marc.MarcField;

public class CatalogEntity {
    private final Map<String, Object> params;

    public CatalogEntity(Map<String, Object> params) {
        this.params = params;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public CatalogEntity transform(CatalogEntityWorker worker, MarcField field) throws IOException {
        worker.append(worker.getWorkerState().getResource(), field, this);
        return this;
    }

    public List<String> transform(CatalogEntityWorker worker, String resourcePredicate, Resource resource, String property, String value) throws IOException {
        return Collections.singletonList(value);
    }

    public Map<String, Object> getCodes() {
        return (Map)this.getParams().get("codes");
    }

    public Map<String, Object> getFacetCodes() {
        return (Map)this.getParams().get("facetcodes");
    }

    protected Map<String, Object> getRegexes() {
        return (Map)this.getParams().get("regexes");
    }

    public Resource getResource(CatalogEntityWorker worker) throws IOException {
        return worker.getWorkerState().getResource();
    }

    protected String getFacetName() {
        return null;
    }

    public TermFacet getDefaultFacet() {
        Object def = this.getParams().get("_default");
        return def != null ? new TermFacet().setName(this.getFacetName()).setType(Literal.STRING).addValue(def.toString()) : new TermFacet();
    }

    protected void facetize(CatalogEntityWorker worker, String value) {
        CatalogEntityWorkerState state = worker.getWorkerState();
        state.getFacets().putIfAbsent(this.getFacetName(), new TermFacet().setName(this.getFacetName()).setType(Literal.STRING));
        state.getFacets().get(this.getFacetName()).addValue(value);
    }

    protected String getValue(MarcField marcField) {
        if (marcField.getValue() != null) {
            return marcField.getValue();
        }
        return ((MarcField.Subfield)marcField.getSubfields().getLast()).getValue();
    }
}

