/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.catalog.entities.marc.nlz;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.xbib.catalog.entities.CatalogEntity;
import org.xbib.catalog.entities.CatalogEntityWorker;
import org.xbib.content.rdf.Resource;
import org.xbib.content.resource.IRI;

public class PersonalName
extends CatalogEntity {
    private static final IRI FOAF_AGENT = IRI.create((String)"foaf:agent");
    private static final IRI FOAF_NAME = IRI.create((String)"foaf:name");
    private static final IRI DC_CREATOR = IRI.create((String)"dc:creator");

    public PersonalName(Map<String, Object> params) {
        super(params);
    }

    @Override
    public List<String> transform(CatalogEntityWorker worker, String resourcePredicate, Resource resource, String property, String value) throws IOException {
        Resource r = worker.getWorkerState().getResource();
        if ("personalName".equals(property)) {
            String name = this.capitalize(value.toLowerCase().substring(0, value.length() - 1), " -");
            r.newResource(DC_CREATOR).a(FOAF_AGENT).add(FOAF_NAME, name);
            worker.getWorkerState().getAuthoredWorkKey().authorName(name);
        }
        return Collections.singletonList(value);
    }

    private String capitalize(String str, String delimiters) {
        int delimLen;
        int n = delimLen = delimiters == null ? -1 : delimiters.length();
        if (str == null || str.isEmpty() || delimLen == 0) {
            return str;
        }
        char[] buffer = str.toCharArray();
        boolean b = true;
        for (int i = 0; i < buffer.length; ++i) {
            char ch = buffer[i];
            if (delimiters != null && delimiters.indexOf(ch) >= 0) {
                b = true;
                continue;
            }
            if (!b) continue;
            buffer[i] = Character.toTitleCase(ch);
            b = false;
        }
        return new String(buffer);
    }
}

