/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.catalog.entities.marc.zdb.bib;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.xbib.catalog.entities.CatalogEntity;
import org.xbib.catalog.entities.CatalogEntityWorker;
import org.xbib.catalog.entities.EnumerationAndChronologyHelper;
import org.xbib.content.rdf.Resource;
import org.xbib.marc.MarcField;

public class EnumerationAndChronology
extends CatalogEntity {
    private List<Pattern> movingwallPatterns;

    public EnumerationAndChronology(Map<String, Object> params) {
        super(params);
        List movingwalls = (List)params.get("movingwall");
        if (movingwalls != null) {
            LinkedList<Pattern> p = new LinkedList<Pattern>();
            for (String movingwall : movingwalls) {
                p.add(Pattern.compile(movingwall));
            }
            this.setMovingwallPatterns(p);
        }
    }

    public List<Pattern> getMovingwallPatterns() {
        return this.movingwallPatterns;
    }

    public void setMovingwallPatterns(List<Pattern> p) {
        this.movingwallPatterns = p;
    }

    @Override
    public CatalogEntity transform(CatalogEntityWorker worker, MarcField field) throws IOException {
        String id = worker.getWorkerState().getIdentifier();
        EnumerationAndChronologyHelper eac = new EnumerationAndChronologyHelper(id, field, this.getMovingwallPatterns());
        for (MarcField.Subfield subfield : field.getSubfields()) {
            if (!"a".equals(subfield.getId())) continue;
            worker.getWorkerState().getResource().add("TextualEnumerationAndChronology", subfield.getValue());
            Resource r = worker.getWorkerState().getResource().newResource("EnumerationAndChronology");
            Resource parsedHoldings = eac.parseToResource(subfield.getValue(), r);
            if (parsedHoldings.isEmpty()) continue;
            Set<Integer> dates = eac.dates(parsedHoldings);
            for (Integer date : dates) {
                worker.getWorkerState().getResource().add("Dates", date);
            }
        }
        return super.transform(worker, field);
    }
}

