/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.catalog.entities.matching.endeavor;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xbib.catalog.entities.matching.endeavor.Identifiable;
import org.xbib.catalog.entities.matching.string.BaseformEncoder;
import org.xbib.catalog.entities.matching.string.EncoderException;
import org.xbib.catalog.entities.matching.string.WordBoundaryEntropyEncoder;

public class AuthoredWork
implements Identifiable {
    private static final Logger logger = Logger.getLogger(AuthoredWork.class.getName());
    private static final Pattern p1 = Pattern.compile(".*Cover and Back matter.*", 2);
    private static final Pattern yearPattern = Pattern.compile("\\d{4}");
    private StringBuilder workName;
    private StringBuilder authorName;
    private StringBuilder chronology;
    private final WordBoundaryEntropyEncoder encoder = new WordBoundaryEntropyEncoder();
    private static final Set<String> blacklist = AuthoredWork.readResource("work-blacklist.txt");

    public AuthoredWork workName(CharSequence workName) {
        if (workName != null) {
            this.workName = new StringBuilder(workName);
        }
        return this;
    }

    public AuthoredWork authorName(Collection<String> authorNames) {
        authorNames.forEach(this::authorName);
        return this;
    }

    public AuthoredWork authorName(String authorName) {
        block9: {
            String[] s;
            if (authorName == null) {
                return this;
            }
            if (this.workName != null && !authorName.isEmpty() && authorName.equals(this.workName.toString())) {
                return this;
            }
            if (this.authorName == null) {
                this.authorName = new StringBuilder();
            }
            if ((s = authorName.split("\\s+")).length <= 0) break block9;
            if (s[0].indexOf(44) >= 0) {
                String lastname = s[0];
                this.authorName.append(lastname);
                if (s.length > 1) {
                    this.authorName.append(' ');
                }
                for (int i = 1; i < s.length; ++i) {
                    if (s[i].length() <= 0) continue;
                    this.authorName.append(s[i].charAt(0));
                }
            } else {
                String lastName = s[s.length - 1];
                this.authorName.append(lastName);
                if (s.length > 1) {
                    this.authorName.append(' ');
                }
                for (int i = 0; i < s.length - 1; ++i) {
                    if (s[i].length() <= 0) continue;
                    this.authorName.append(s[i].charAt(0));
                }
            }
        }
        return this;
    }

    public AuthoredWork authorNameWithForeNames(String lastName, String foreName) {
        if (foreName == null) {
            return this.authorName(lastName);
        }
        StringBuilder sb = new StringBuilder();
        for (String s : foreName.split("\\s+")) {
            if (s.length() <= 0) continue;
            sb.append(s.charAt(0));
        }
        if (lastName != null) {
            if (this.authorName == null) {
                this.authorName = new StringBuilder(lastName);
                if (sb.length() > 0) {
                    this.authorName.append(' ').append((CharSequence)sb);
                }
            } else {
                this.authorName.append(lastName);
                if (sb.length() > 0) {
                    this.authorName.append(' ').append((CharSequence)sb);
                }
            }
        }
        return this;
    }

    public AuthoredWork authorNameWithInitials(String lastName, String initials) {
        boolean b;
        String s = initials;
        if (s != null) {
            s = s.replaceAll("\\s+", "");
        }
        boolean bl = b = s != null && s.length() > 0;
        if (lastName != null) {
            if (this.authorName == null) {
                this.authorName = new StringBuilder(lastName);
                if (b) {
                    this.authorName.append(' ').append(s);
                }
            } else {
                this.authorName.append(lastName);
                if (b) {
                    this.authorName.append(' ').append(s);
                }
            }
        }
        return this;
    }

    public AuthoredWork year(String year) {
        Matcher matcher = yearPattern.matcher(year);
        if (matcher.find()) {
            this.chronology(matcher.group());
        }
        return this;
    }

    public AuthoredWork chronology(String chronology) {
        if (chronology != null) {
            if (this.chronology == null) {
                this.chronology = new StringBuilder();
            }
            this.chronology.append(".").append(chronology.replaceAll("\\s+", ""));
        }
        return this;
    }

    @Override
    public String createIdentifier() {
        if (this.workName == null || this.workName.length() == 0) {
            return null;
        }
        if (!this.isValidWork()) {
            return null;
        }
        String wName = BaseformEncoder.normalizedFromUTF8(this.workName.toString()).replaceAll("aeiou", "");
        try {
            wName = this.encoder.encode(wName);
        }
        catch (EncoderException e) {
            logger.log(Level.FINE, e.getMessage(), e);
        }
        if (this.isBlacklisted(this.workName)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("w").append(wName);
        if (this.authorName != null) {
            String aName = BaseformEncoder.normalizedFromUTF8(this.authorName.toString()).replaceAll("aeiou", "");
            try {
                aName = this.encoder.encode(aName);
            }
            catch (EncoderException e) {
                logger.log(Level.FINE, e.getMessage(), e);
            }
            sb.append(".a").append(aName);
        }
        if (this.chronology != null) {
            sb.append((CharSequence)this.chronology);
        }
        return sb.toString();
    }

    public boolean isValidWork() {
        int pos;
        if (this.workName == null) {
            return false;
        }
        return this.authorName != null || (pos = this.workName.toString().indexOf(32)) >= 0;
    }

    public Set<String> blacklist() {
        return blacklist;
    }

    public boolean isBlacklisted(CharSequence work) {
        return blacklist.contains(work.toString()) || p1.matcher(work).matches();
    }

    private static Set<String> readResource(String resource) {
        URL url = AuthoredWork.class.getResource(resource);
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        if (url != null) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));){
                reader.lines().filter(line -> !line.startsWith("#")).forEach(set::add);
            }
            catch (IOException e) {
                logger.log(Level.FINE, e.getMessage(), e);
            }
        }
        return set;
    }
}

