/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.catalog.entities.mab;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.xbib.catalog.entities.CatalogEntity;
import org.xbib.catalog.entities.CatalogEntityWorker;
import org.xbib.catalog.entities.CatalogEntityWorkerState;
import org.xbib.catalog.entities.Classifier;
import org.xbib.catalog.entities.ClassifierEntry;
import org.xbib.catalog.entities.IdentifierMapper;
import org.xbib.catalog.entities.TermFacet;
import org.xbib.content.rdf.Literal;
import org.xbib.content.rdf.Resource;
import org.xbib.content.resource.IRI;
import org.xbib.marc.MarcField;

public class OnlineAccess
extends CatalogEntity {
    private static final String taxonomyFacet = "xbib.taxonomy";
    private static final String identifierFacet = "xbib.identifier";

    public OnlineAccess(Map<String, Object> params) {
        super(params);
    }

    @Override
    public CatalogEntity transform(CatalogEntityWorker worker, MarcField fields) throws IOException {
        worker.append(worker.getWorkerState().getNextItemResource(), fields, this);
        return null;
    }

    @Override
    public List<String> transform(CatalogEntityWorker worker, String predicate, Resource resource, String property, String value) {
        CatalogEntityWorkerState state = worker.getWorkerState();
        String isil = value;
        if ("uri".equals(property)) {
            state.setUID(IRI.builder().curie("uid:" + value).build());
        } else if ("identifier".equals(property)) {
            String key;
            Collection<ClassifierEntry> entries;
            IdentifierMapper mapper = worker.getIdentifierMapper();
            if (mapper != null) {
                isil = mapper.lookup(value);
                state.setISIL(isil);
                state.getFacets().putIfAbsent(identifierFacet, new TermFacet().setName(identifierFacet).setType(Literal.STRING));
                state.getFacets().get(identifierFacet).addValue(isil);
                IRI uid = state.getUID();
                if (uid != null) {
                    state.setUID(IRI.builder().curie("uid:" + state.getRecordIdentifier() + "/" + state.getISIL() + "/" + uid.getSchemeSpecificPart()).build());
                }
            }
            resource.add("identifier", isil);
            Classifier classifier = worker.getClassifier();
            if (classifier != null && (entries = classifier.lookup(key = isil + "." + state.getRecordIdentifier() + ".")) != null) {
                for (ClassifierEntry classifierEntry : entries) {
                    String facet = "xbib.taxonomy." + isil + ".notation";
                    state.getFacets().putIfAbsent(facet, new TermFacet().setName(facet).setType(Literal.STRING));
                    state.getFacets().get(facet).addValue(classifierEntry.getCode());
                    facet = "xbib.taxonomy." + isil + ".text";
                    state.getFacets().putIfAbsent(facet, new TermFacet().setName(facet).setType(Literal.STRING));
                    state.getFacets().get(facet).addValue(classifierEntry.getText());
                }
            }
        }
        return Collections.singletonList(isil);
    }
}

