/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.catalog.entities;

import java.io.IOException;
import org.xbib.catalog.entities.CatalogEntityBuilder;
import org.xbib.catalog.entities.CatalogEntityWorker;
import org.xbib.content.rdf.Resource;
import org.xbib.content.rdf.internal.DefaultAnonymousResource;
import org.xbib.marc.MarcField;
import org.xbib.marc.MarcRecord;

public class CatalogUnmappedEntityWorker
extends CatalogEntityWorker {
    CatalogUnmappedEntityWorker(CatalogEntityBuilder entityBuilder) {
        super(entityBuilder);
    }

    @Override
    public void build(MarcRecord marcRecord) throws IOException {
        for (MarcField field : marcRecord.getFields()) {
            DefaultAnonymousResource resource = new DefaultAnonymousResource();
            if (field.isControl()) {
                if ("001".equals(field.getTag())) {
                    this.getWorkerState().setRecordIdentifier(field.getValue());
                }
                resource.add("_", field.getValue());
            } else {
                for (MarcField.Subfield subfield : field.getSubfields()) {
                    resource.newResource(field.getIndicator().replaceAll("\\s", "_")).add(subfield.getId(), subfield.getValue());
                }
            }
            this.getWorkerState().getResource().add(field.getTag(), (Resource)resource);
        }
    }
}

