/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.catalog.entities;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xbib.catalog.entities.IdentifierMapper;
import org.xbib.catalog.entities.ValueMapper;
import org.xbib.content.settings.Settings;
import org.xbib.marc.transformer.value.MarcValueTransformer;
import org.xbib.marc.transformer.value.MarcValueTransformers;

public class ISILTransformer
implements MarcValueTransformer {
    private static final Logger logger = Logger.getLogger(ISILTransformer.class.getName());
    private final IdentifierMapper identifierMapper = new IdentifierMapper();

    public ISILTransformer(Settings settings) throws IOException {
        ValueMapper valueMapper = new ValueMapper();
        Map<String, Object> sigel2isil = valueMapper.getMap(settings.get("sigel2isil", "org/xbib/catalog/entities/mab/sigel2isil.json"), "sigel2isil");
        this.identifierMapper.add(sigel2isil);
        URL url = this.getClass().getClassLoader().getResource(settings.get("tab_sigel", "org/xbib/catalog/entities/mab/hbz/tab_sigel"));
        try {
            if (url != null) {
                this.identifierMapper.load(url.openStream(), StandardCharsets.ISO_8859_1);
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "unable to load tab_sigel from classpath", e);
        }
    }

    public String transform(String value) {
        return this.identifierMapper.lookup(value);
    }

    public void createTransformer(Settings settings, MarcValueTransformers marcValueTransformers) throws IOException {
        String resource = settings.get("transform2isil");
        List transform2isil = resource.endsWith(".json") ? (List)new ObjectMapper().readValue(this.getClass().getClassLoader().getResource(resource).openStream(), List.class) : Arrays.asList(settings.getAsArray("transform2isil"));
        logger.log(Level.INFO, () -> MessageFormat.format("transform2isil: {0}", transform2isil.size()));
        for (String field : transform2isil) {
            marcValueTransformers.setMarcValueTransformer(field, (MarcValueTransformer)this);
        }
    }
}

