/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.catalog.entities.mab;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xbib.catalog.entities.CatalogEntity;
import org.xbib.catalog.entities.CatalogEntityWorker;
import org.xbib.catalog.entities.CatalogEntityWorkerState;
import org.xbib.catalog.entities.Classifier;
import org.xbib.catalog.entities.ClassifierEntry;
import org.xbib.catalog.entities.IdentifierMapper;
import org.xbib.catalog.entities.TermFacet;
import org.xbib.catalog.entities.ValueMapper;
import org.xbib.content.rdf.Literal;
import org.xbib.content.rdf.Resource;
import org.xbib.content.resource.IRI;
import org.xbib.marc.MarcField;

public class Item
extends CatalogEntity {
    private static final Logger logger = Logger.getLogger(Item.class.getName());
    private static final String taxonomyFacet = "xbib.taxonomy";
    private static final String identifierFacet = "xbib.identifier";

    public Item(Map<String, Object> params) {
        super(params);
    }

    @Override
    public CatalogEntity transform(CatalogEntityWorker worker, MarcField field) throws IOException {
        worker.append(worker.getWorkerState().getNextItemResource(), field, this);
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public List<String> transform(CatalogEntityWorker worker, String predicate, Resource resource, String property, String value) {
        CatalogEntityWorkerState state = worker.getWorkerState();
        if ("identifier".equals(property)) {
            Classifier classifier2;
            IdentifierMapper mapper = worker.getIdentifierMapper();
            if (mapper == null) return Collections.singletonList(value);
            String isil = mapper.lookup(value);
            if (isil == null) {
                logger.log(Level.WARNING, () -> MessageFormat.format("ISIL lookup failed for {0}", value));
                return Collections.singletonList(value);
            }
            resource.add("identifier", isil);
            state.setUID(IRI.builder().curie(isil).build());
            state.setISIL(isil);
            state.getFacets().putIfAbsent(identifierFacet, new TermFacet().setName(identifierFacet).setType(Literal.STRING));
            TermFacet holderFacet = state.getFacets().get(identifierFacet);
            holderFacet.addValue(isil);
            int pos = isil.lastIndexOf(45);
            if (isil.indexOf(45) < pos) {
                holderFacet.addValue(isil.substring(0, pos));
            }
            if ((classifier2 = worker.getClassifier()) == null) return Collections.singletonList(isil);
            String doc = state.getRecordIdentifier();
            Collection<ClassifierEntry> entries = classifier2.lookup(isil, doc, value, null);
            if (entries == null) return Collections.singletonList(isil);
            Iterator<ClassifierEntry> iterator = entries.iterator();
            while (iterator.hasNext()) {
                ClassifierEntry classifierEntry = iterator.next();
                String facet = "xbib.taxonomy." + isil + ".notation";
                state.getFacets().putIfAbsent(facet, new TermFacet().setName(facet).setType(Literal.STRING));
                state.getFacets().get(facet).addValue(classifierEntry.getCode());
                facet = "xbib.taxonomy." + isil + ".text";
                state.getFacets().putIfAbsent(facet, new TermFacet().setName(facet).setType(Literal.STRING));
                state.getFacets().get(facet).addValue(classifierEntry.getText());
            }
            return Collections.singletonList(isil);
        }
        if ("callnumber".equals(property)) {
            String doc;
            state.setUID(IRI.builder().curie(state.getISIL() + "/" + value).build());
            Classifier classifier = worker.getClassifier();
            if (classifier == null) return Collections.singletonList(value);
            String isil = state.getISIL();
            Collection<ClassifierEntry> entries = classifier.lookup(isil, doc = state.getRecordIdentifier(), value, null);
            if (entries == null) return Collections.singletonList(value);
            Iterator<ClassifierEntry> classifier2 = entries.iterator();
            while (classifier2.hasNext()) {
                ClassifierEntry classifierEntry = classifier2.next();
                String facet = "xbib.taxonomy." + isil + ".notation";
                state.getFacets().putIfAbsent(facet, new TermFacet().setName(facet).setType(Literal.STRING));
                state.getFacets().get(facet).addValue(classifierEntry.getCode());
                facet = "xbib.taxonomy." + isil + ".text";
                state.getFacets().putIfAbsent(facet, new TermFacet().setName(facet).setType(Literal.STRING));
                state.getFacets().get(facet).addValue(classifierEntry.getText());
            }
            return Collections.singletonList(value);
        }
        if (!"status".equals(property)) {
            if (!"publicnote".equals(property)) return Collections.singletonList(value);
            if (!"Frei zug\u00e4nglich".equals(value)) return Collections.singletonList(value);
            state.setUID(IRI.builder().curie("green").build());
            return Collections.singletonList(value);
        }
        ValueMapper mapper = worker.getValueMapper();
        if (mapper == null) return Collections.singletonList(value);
        Map<String, Object> map = mapper.getMap("status");
        if (!map.containsKey(value)) return Collections.singletonList(value);
        List codes = (List)map.get(value);
        if (codes == null) return Collections.singletonList(value);
        Iterator iterator = codes.iterator();
        while (iterator.hasNext()) {
            String code = (String)iterator.next();
            resource.add("interlibraryservice", code);
        }
        return Collections.singletonList(value);
    }
}

