/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.marc.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import org.xbib.marc.MarcField;
import org.xbib.marc.MarcListener;
import org.xbib.marc.transformer.value.MarcValueTransformers;

public class MarcXchangeJSONLinesReader
implements Closeable {
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private static final JsonFactory factory = new JsonFactory();
    private final Reader reader;
    private final MarcListener listener;
    private final int bufferSize;
    private JsonParser jsonParser;
    private MarcField.Builder marcFieldBuilder;
    private String format;
    private String type;
    private String leader;
    private MarcValueTransformers marcValueTransformers;

    public MarcXchangeJSONLinesReader(InputStream in) throws IOException {
        this(new InputStreamReader(in, StandardCharsets.UTF_8), 8192, null);
    }

    public MarcXchangeJSONLinesReader(InputStream in, MarcListener listener) throws IOException {
        this(new InputStreamReader(in, StandardCharsets.UTF_8), 8192, listener);
    }

    public MarcXchangeJSONLinesReader(InputStream in, int buffersize, MarcListener listener) throws IOException {
        this(new InputStreamReader(in, StandardCharsets.UTF_8), buffersize, listener);
    }

    public MarcXchangeJSONLinesReader(Reader reader, MarcListener listener) {
        this(reader, 8192, listener);
    }

    public MarcXchangeJSONLinesReader(Reader reader, int bufferSize, MarcListener listener) {
        this.reader = reader;
        this.listener = listener == null ? new EmptyListener() : listener;
        this.bufferSize = bufferSize;
    }

    public void setMarcValueTransformers(MarcValueTransformers marcValueTransformers) {
        this.marcValueTransformers = marcValueTransformers;
    }

    public void parse() throws IOException {
        try (BufferedReader bufferedReader = new BufferedReader(this.reader, this.bufferSize);){
            this.listener.beginCollection();
            bufferedReader.lines().forEach(this::parse);
            this.listener.endCollection();
        }
    }

    private void parse(String line) {
        try {
            this.jsonParser = factory.createParser(line);
            this.jsonParser.nextToken();
            this.marcFieldBuilder = MarcField.builder();
            this.parseRecord();
            this.listener.endRecord();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void parseRecord() throws IOException {
        String tag = null;
        JsonToken currentToken = this.jsonParser.getCurrentToken();
        while (currentToken != null && currentToken != JsonToken.END_OBJECT) {
            if (JsonToken.FIELD_NAME.equals((Object)currentToken)) {
                tag = this.jsonParser.getCurrentName();
                this.marcFieldBuilder = MarcField.builder().tag(tag);
            } else if (JsonToken.START_ARRAY.equals((Object)currentToken)) {
                this.parseTags();
            } else if (tag != null && currentToken.isScalarValue()) {
                String value = this.jsonParser.getText();
                switch (tag) {
                    case "_FORMAT": {
                        this.format = value;
                        break;
                    }
                    case "_TYPE": {
                        this.type = value;
                        break;
                    }
                    case "_LEADER": {
                        this.leader = value;
                        break;
                    }
                }
                this.marcFieldBuilder.value(value);
                this.emit();
            }
            currentToken = this.jsonParser.nextToken();
        }
    }

    private void parseTags() throws IOException {
        block13: {
            JsonToken currentToken;
            block12: {
                currentToken = this.jsonParser.getCurrentToken();
                if (currentToken != JsonToken.START_ARRAY) break block12;
                while (currentToken != null && currentToken != JsonToken.END_ARRAY) {
                    if (JsonToken.FIELD_NAME.equals((Object)currentToken)) {
                        this.marcFieldBuilder = MarcField.builder().tag(this.jsonParser.getCurrentName());
                    } else if (JsonToken.START_OBJECT.equals((Object)currentToken)) {
                        this.parseIndicators();
                    } else if (currentToken.isScalarValue()) {
                        String value = this.jsonParser.getText();
                        this.marcFieldBuilder.value(value);
                        this.emit();
                    }
                    currentToken = this.jsonParser.nextToken();
                }
                break block13;
            }
            if (currentToken != JsonToken.START_OBJECT) break block13;
            while (currentToken != null && currentToken != JsonToken.END_OBJECT) {
                if (JsonToken.FIELD_NAME.equals((Object)currentToken)) {
                    this.marcFieldBuilder = MarcField.builder().tag(this.jsonParser.getCurrentName());
                } else if (JsonToken.START_OBJECT.equals((Object)currentToken)) {
                    this.parseIndicators();
                } else if (currentToken.isScalarValue()) {
                    String value = this.jsonParser.getText();
                    this.marcFieldBuilder.value(value);
                    this.emit();
                }
                currentToken = this.jsonParser.nextToken();
            }
        }
    }

    private void parseIndicators() throws IOException {
        JsonToken currentToken = this.jsonParser.getCurrentToken();
        while (currentToken != null && currentToken != JsonToken.END_ARRAY) {
            if (JsonToken.FIELD_NAME.equals((Object)currentToken)) {
                String indicator = this.jsonParser.getCurrentName().replace('_', ' ');
                this.marcFieldBuilder.indicator(indicator);
            } else if (JsonToken.START_ARRAY.equals((Object)currentToken)) {
                String tag = this.marcFieldBuilder.tag();
                String indicator = this.marcFieldBuilder.indicator();
                this.parseSubfields();
                this.emit();
                this.marcFieldBuilder = MarcField.builder().tag(tag).indicator(indicator);
            }
            currentToken = this.jsonParser.nextToken();
        }
    }

    private void parseSubfields() throws IOException {
        JsonToken currentToken = this.jsonParser.getCurrentToken();
        while (currentToken != null && currentToken != JsonToken.END_ARRAY) {
            if (JsonToken.FIELD_NAME.equals((Object)currentToken)) {
                this.marcFieldBuilder.subfield(this.jsonParser.getCurrentName());
            } else if (currentToken.isScalarValue()) {
                String value = this.jsonParser.getText();
                if (this.marcFieldBuilder.hasSubfields()) {
                    this.marcFieldBuilder.subfieldValue(value);
                } else {
                    this.marcFieldBuilder.value(value);
                }
            }
            currentToken = this.jsonParser.nextToken();
        }
    }

    private void emit() {
        if (this.format != null || this.type != null) {
            if (this.format != null && this.type != null) {
                this.listener.beginRecord(this.format, this.type);
                this.format = null;
                this.type = null;
            }
        } else if (this.leader != null) {
            this.listener.leader(this.leader);
            this.leader = null;
        } else {
            MarcField marcField = this.marcFieldBuilder.build();
            this.listener.field(this.marcValueTransformers != null ? this.marcValueTransformers.transformValue(marcField) : marcField);
        }
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    private class EmptyListener
    implements MarcListener {
        private EmptyListener() {
        }

        public void beginCollection() {
        }

        public void beginRecord(String format, String type) {
        }

        public void leader(String label) {
        }

        public void field(MarcField field) {
        }

        public void endRecord() {
        }

        public void endCollection() {
        }
    }
}

