/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.catalog.entities;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import org.xbib.catalog.entities.CatalogEntity;
import org.xbib.catalog.entities.CatalogEntityBuilder;
import org.xbib.catalog.entities.CatalogEntityWorkerState;
import org.xbib.catalog.entities.Classifier;
import org.xbib.catalog.entities.IdentifierMapper;
import org.xbib.catalog.entities.ValueMapper;
import org.xbib.catalog.entities.Worker;
import org.xbib.content.rdf.Resource;
import org.xbib.content.resource.IRI;
import org.xbib.marc.MarcField;
import org.xbib.marc.MarcRecord;
import org.xbib.marc.label.RecordLabel;

public class CatalogEntityWorker
implements Worker<MarcRecord> {
    private static final Logger logger = Logger.getLogger(CatalogEntityWorker.class.getName());
    private static final IRI tempPredicate = IRI.create((String)"tmp");
    private final CatalogEntityBuilder entityBuilder;
    private final CRC32 crc32;
    private MarcRecord marcRecord;
    private CatalogEntityWorkerState state;

    public CatalogEntityWorker(CatalogEntityBuilder entityBuilder) {
        this.entityBuilder = entityBuilder;
        this.crc32 = new CRC32();
    }

    @Override
    public void execute(MarcRecord marcRecord) throws IOException {
        this.marcRecord = marcRecord;
        this.state = this.newState();
        try {
            this.build(marcRecord);
        }
        finally {
            this.entityBuilder.beforeFinishState(this.state);
            this.state.finish();
            this.entityBuilder.afterFinishState(this.state);
        }
    }

    @Override
    public MarcRecord getRequest() {
        return this.marcRecord;
    }

    protected CatalogEntityWorkerState newState() {
        return new CatalogEntityWorkerState(this.entityBuilder);
    }

    public CatalogEntityWorkerState getWorkerState() {
        return this.state;
    }

    public Classifier getClassifier() {
        return this.entityBuilder.getClassifier();
    }

    public IdentifierMapper getIdentifierMapper() {
        return this.entityBuilder.getIdentifierMapper();
    }

    public ValueMapper getValueMapper() {
        return this.entityBuilder.getValueMapper();
    }

    protected void build(MarcRecord marcRecord) throws IOException {
        if (this.entityBuilder.isEnableChecksum()) {
            this.crc32.reset();
        }
        this.buildFormat(marcRecord.getFormat());
        this.buildType(marcRecord.getType());
        this.build(marcRecord.getRecordLabel());
        for (MarcField marcField : marcRecord.getFields()) {
            this.build(marcField);
        }
        if (this.entityBuilder.isEnableChecksum()) {
            this.crc32.update(marcRecord.getFields().toString().getBytes(StandardCharsets.UTF_8));
            this.getWorkerState().getResource().add(IRI.builder().curie("crc").build(), Long.toHexString(this.crc32.getValue()));
            this.entityBuilder.checksum(this.crc32);
        }
        this.entityBuilder.getCounter().incrementAndGet();
    }

    public void buildFormat(String format) throws IOException {
        CatalogEntity entity = this.entityBuilder.getEntitySpecification().retrieveFormat();
        if (entity != null) {
            entity.transform(this, MarcField.builder().tag("_FORMAT").value(format).build());
        }
    }

    public void buildType(String format) throws IOException {
        CatalogEntity entity = this.entityBuilder.getEntitySpecification().retrieveType();
        if (entity != null) {
            entity.transform(this, MarcField.builder().tag("_TYPE").value(format).build());
        }
    }

    public void build(RecordLabel recordLabel) throws IOException {
        CatalogEntity entity = this.entityBuilder.getEntitySpecification().retrieveLeader();
        if (entity != null) {
            entity.transform(this, MarcField.builder().tag("_LEADER").value(recordLabel.toString()).build());
        }
    }

    public void build(MarcField marcField) throws IOException {
        if (!marcField.isTagValid()) {
            this.entityBuilder.invalid(this.getWorkerState().getRecordIdentifier(), marcField, "field " + marcField + ": invalid tag");
            return;
        }
        if (!marcField.isIndicatorValid()) {
            this.entityBuilder.invalid(this.getWorkerState().getRecordIdentifier(), marcField, "field " + marcField + " invalid indicator");
            return;
        }
        CatalogEntity entity = this.entityBuilder.getEntitySpecification().retrieve(marcField);
        if (entity != null) {
            entity.transform(this, marcField);
            this.entityBuilder.mapped(this.getWorkerState().getRecordIdentifier(), marcField);
        } else {
            this.entityBuilder.unmapped(this.getWorkerState().getRecordIdentifier(), marcField, "field " + marcField + " tag definition missing in specification");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "field=" + marcField + " entity=" + entity);
        }
    }

    public Resource append(Resource resource, MarcField field, CatalogEntity entity) throws IOException {
        Map indicatorMap;
        Map indicators;
        Map tags;
        Object o;
        Map<String, Object> params = entity.getParams();
        Map defaultSubfields = (Map)params.get("subfields");
        if (defaultSubfields == null) {
            return resource;
        }
        HashMap<MarcField, String> fieldNames = new HashMap<MarcField, String>();
        Resource newResource = resource.newResource(tempPredicate);
        String predicate = entity.getClass().getSimpleName();
        if (params.containsKey("_predicate")) {
            predicate = (String)params.get("_predicate");
        }
        String tag = field.getTag();
        Map subfields = defaultSubfields;
        if (params.containsKey("tags") && (o = params.get("tags")) instanceof Map && (tags = (Map)o).containsKey(tag) && (subfields = (Map)params.get(predicate = (String)tags.get(tag))) == null) {
            subfields = defaultSubfields;
        }
        String indicator = field.getIndicator();
        if (params.containsKey("indicators") && (indicators = (Map)params.get("indicators")).containsKey(tag) && (indicatorMap = (Map)indicators.get(tag)).containsKey(indicator)) {
            predicate = (String)indicatorMap.get(indicator);
            fieldNames.put(field, predicate);
            subfields = (Map)params.get(predicate);
            if (subfields == null) {
                subfields = defaultSubfields;
            }
        }
        if (field.isControl()) {
            predicate = this.append(newResource, entity, field, "", field.getValue(), fieldNames, subfields, predicate);
        }
        for (MarcField.Subfield subfield : field.getSubfields()) {
            predicate = this.append(newResource, entity, field, subfield.getId(), subfield.getValue(), fieldNames, subfields, predicate);
        }
        if (predicate != null) {
            resource.rename(tempPredicate, IRI.builder().curie(predicate).build());
        }
        return newResource;
    }

    protected String append(Resource newResource, CatalogEntity entity, MarcField field, String subfieldIdentifier, String value, Map<MarcField, String> fieldNames, Map<String, Object> subfields, String predicate) throws IOException {
        String pred = predicate;
        String subfieldId = subfieldIdentifier;
        Map<String, Object> params = entity.getParams();
        Map.Entry<String, Object> me = CatalogEntityWorker.subfieldDecoderMap(subfields, subfieldId, value);
        if (me.getKey() != null && me.getValue() != null) {
            String fieldName;
            String v = me.getValue().toString();
            if (fieldNames.containsKey(field)) {
                Object o;
                fieldName = fieldNames.get(field);
                List patterns = (List)params.get(fieldName + "pattern");
                if (patterns != null) {
                    for (Map pattern : patterns) {
                        Map.Entry mme = pattern.entrySet().iterator().next();
                        String p = (String)mme.getKey();
                        String rel = (String)mme.getValue();
                        Matcher m = Pattern.compile(p, 2).matcher(v);
                        if (!m.matches()) continue;
                        v = rel;
                        break;
                    }
                } else if (params.containsKey(me.getKey()) && (o = params.get(me.getKey())) instanceof Map) {
                    Map vm = (Map)o;
                    v = vm.containsKey(v) ? vm.get(v).toString() : v;
                }
            } else {
                fieldName = me.getKey();
                if (params.containsKey(fieldName)) {
                    Object o = params.get(fieldName);
                    if (o instanceof Map) {
                        String vv;
                        Map vm = (Map)o;
                        int pos = v.indexOf(32);
                        String string = vv = pos > 0 ? v.substring(0, pos) : v;
                        if (vm.containsKey(v)) {
                            v = (String)vm.get(v);
                        } else if (vm.containsKey(vv)) {
                            v = (String)vm.get(vv);
                        } else {
                            List patterns = (List)params.get(fieldName + "pattern");
                            if (patterns != null) {
                                for (Map pattern : patterns) {
                                    Map.Entry mme = pattern.entrySet().iterator().next();
                                    String p = (String)mme.getKey();
                                    String rel = (String)mme.getValue();
                                    Matcher m = Pattern.compile(p, 2).matcher(v);
                                    if (!m.matches()) continue;
                                    v = rel;
                                    break;
                                }
                            }
                        }
                    } else if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "entity=" + entity + ": not a map found in params for key '" + fieldName + "'");
                    }
                }
            }
            List<String> transformed = null;
            if (v != null) {
                transformed = entity.transform(this, pred, newResource, me.getKey(), v);
            }
            if (me.getKey().equals(pred)) {
                pred = v;
            } else if (transformed != null) {
                for (String t : transformed) {
                    newResource.add(me.getKey(), t);
                }
            }
        } else {
            if (subfieldId.isEmpty()) {
                subfieldId = " ";
            }
            if (subfields.containsKey(subfieldId)) {
                String property = (String)subfields.get(subfieldId);
                List<String> transformed = entity.transform(this, pred, newResource, property, value);
                if (transformed != null) {
                    for (String t : transformed) {
                        newResource.add(property, t);
                    }
                }
            } else {
                this.entityBuilder.unmapped(this.getWorkerState().getRecordIdentifier(), field, "field " + field + " missing definition for subfield '" + subfieldId + "' subfields=" + subfields);
            }
        }
        return pred;
    }

    private static Map.Entry<String, Object> subfieldDecoderMap(Map<String, Object> subfields, String subfieldID, String value) {
        String k = null;
        String v = value;
        Object subfieldDef = subfields.get(subfieldID);
        if (subfieldDef instanceof Map) {
            Map subfieldmap = (Map)subfieldDef;
            if (subfieldmap.containsKey(v.toString())) {
                Object o = subfieldmap.get(v.toString());
                if (o instanceof Map) {
                    Map.Entry me = ((Map)o).entrySet().iterator().next();
                    k = (String)me.getKey();
                    v = me.getValue();
                } else {
                    v = o;
                }
            }
        } else {
            k = (String)subfieldDef;
        }
        final String newKey = k;
        final String newValue = v;
        return new Map.Entry<String, Object>(){

            @Override
            public String getKey() {
                return newKey;
            }

            @Override
            public Object getValue() {
                return newValue;
            }

            @Override
            public Object setValue(Object value) {
                return null;
            }
        };
    }
}

