/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.catalog.entities.mab;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xbib.catalog.entities.CatalogEntity;
import org.xbib.catalog.entities.CatalogEntityWorker;
import org.xbib.content.rdf.Resource;
import org.xbib.marc.MarcField;

public class Preservation
extends CatalogEntity {
    private Map<Pattern, String> patterns;

    public Preservation(Map<String, Object> params) {
        super(params);
        Map<String, Object> regexes = this.getRegexes();
        if (regexes != null) {
            this.patterns = new HashMap<Pattern, String>();
            for (Map.Entry<String, Object> entry : regexes.entrySet()) {
                String key = entry.getKey();
                this.patterns.put(Pattern.compile(Pattern.quote(key), 2), (String)regexes.get(key));
            }
        }
    }

    @Override
    public CatalogEntity transform(CatalogEntityWorker worker, MarcField field) throws IOException {
        String value = this.getValue(field);
        Resource resource = worker.getWorkerState().getResource().newResource("Preservation");
        for (String code : this.findCodes(value)) {
            resource.add("value", code);
        }
        return null;
    }

    private List<String> findCodes(String value) {
        LinkedList<String> list = new LinkedList<String>();
        Map rak = (Map)this.getParams().get("rak");
        if (rak != null && rak.containsKey(value)) {
            list.add((String)rak.get(value));
        }
        if (this.patterns != null) {
            for (Map.Entry<Pattern, String> entry : this.patterns.entrySet()) {
                String v;
                Pattern p = entry.getKey();
                Matcher m = p.matcher(value);
                if (!m.find() || (v = this.patterns.get(p)) == null) continue;
                list.add(v);
            }
        } else if (list.isEmpty()) {
            list.add(value);
        }
        return list;
    }
}

