/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.catalog.entities.mab;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xbib.catalog.entities.CatalogEntity;
import org.xbib.catalog.entities.CatalogEntityWorker;
import org.xbib.catalog.entities.CatalogEntityWorkerState;
import org.xbib.catalog.entities.Classifier;
import org.xbib.catalog.entities.ClassifierEntry;
import org.xbib.catalog.entities.TermFacet;
import org.xbib.content.rdf.Literal;
import org.xbib.marc.MarcField;

public class RecordIdentifier
extends CatalogEntity {
    private static final Logger logger = Logger.getLogger(RecordIdentifier.class.getName());
    private static final String taxonomyFacet = "xbib.taxonomy";
    private String prefix = "";
    private String catalogid = "";

    public RecordIdentifier(Map<String, Object> params) {
        super(params);
        if (params.containsKey("_prefix")) {
            this.prefix = params.get("_prefix").toString();
        }
        if (params.containsKey("catalogid")) {
            this.catalogid = params.get("catalogid").toString();
            this.prefix = "(" + this.catalogid + ")";
        }
    }

    @Override
    public CatalogEntity transform(CatalogEntityWorker worker, MarcField field) throws IOException {
        String value = this.getValue(field);
        CatalogEntityWorkerState state = worker.getWorkerState();
        String v = this.prefix + value.trim();
        if (state.getRecordIdentifier() == null) {
            state.setIdentifier(v);
            state.setRecordIdentifier(v);
            state.getResource().newResource("xbib").add("uid", v);
        } else {
            logger.log(Level.WARNING, () -> MessageFormat.format("record identifier already set, skipping {0}", value));
        }
        Classifier classifier = worker.getClassifier();
        if (classifier != null) {
            String isil = this.catalogid;
            String key = this.catalogid + "." + state.getRecordIdentifier() + ".";
            Collection<ClassifierEntry> entries = classifier.lookup(key);
            if (entries != null) {
                for (ClassifierEntry classifierEntry : entries) {
                    String facet;
                    if (classifierEntry.getCode() != null && !classifierEntry.getCode().trim().isEmpty()) {
                        facet = "xbib.taxonomy." + isil + ".notation";
                        state.getFacets().putIfAbsent(facet, new TermFacet().setName(facet).setType(Literal.STRING));
                        state.getFacets().get(facet).addValue(classifierEntry.getCode());
                    }
                    if (classifierEntry.getText() == null || classifierEntry.getText().trim().isEmpty()) continue;
                    facet = "xbib.taxonomy." + isil + ".text";
                    state.getFacets().putIfAbsent(facet, new TermFacet().setName(facet).setType(Literal.STRING));
                    state.getFacets().get(facet).addValue(classifierEntry.getText());
                }
            }
        }
        return super.transform(worker, field);
    }
}

