/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.catalog.entities.mab;

import java.io.IOException;
import java.util.Map;
import org.xbib.catalog.entities.CatalogEntity;
import org.xbib.catalog.entities.CatalogEntityWorker;
import org.xbib.catalog.entities.TermFacet;
import org.xbib.content.rdf.Literal;
import org.xbib.content.rdf.Resource;
import org.xbib.marc.MarcField;

public class SimpleCarrier
extends CatalogEntity {
    public static final String FACET = "dc.format";
    private Map<String, Object> codes = this.getCodes();
    private Map<String, Object> facetcodes = this.getFacetCodes();

    public SimpleCarrier(Map<String, Object> params) {
        super(params);
    }

    @Override
    public CatalogEntity transform(CatalogEntityWorker worker, MarcField field) throws IOException {
        String value = this.getValue(field);
        if (this.codes != null) {
            Resource resource = worker.getWorkerState().getResource().newResource("Carrier");
            for (int i = 0; i < value.length(); ++i) {
                String code = (String)this.codes.get(value.substring(i, i + 1));
                if (code == null && i + 1 < value.length()) {
                    code = (String)this.codes.get(value.substring(i, i + 2));
                }
                resource.add("value", code);
                code = (String)this.facetcodes.get(value.substring(i, i + 1));
                if (code == null && i + 1 < value.length()) {
                    code = (String)this.facetcodes.get(value.substring(i, i + 2));
                }
                worker.getWorkerState().getFacets().putIfAbsent(FACET, new TermFacet().setName(FACET).setType(Literal.STRING));
                worker.getWorkerState().getFacets().get(FACET).addValue(code);
            }
        }
        return super.transform(worker, field);
    }
}

