/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.catalog.entities.marc.bib;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xbib.catalog.entities.CatalogEntity;
import org.xbib.catalog.entities.CatalogEntityWorker;
import org.xbib.content.rdf.Resource;
import org.xbib.marc.MarcField;

public class PhysicalDescriptionCode
extends CatalogEntity {
    private static final Logger logger = Logger.getLogger(PhysicalDescriptionCode.class.getName());
    private final Map<String, Object> codes;

    public PhysicalDescriptionCode(Map<String, Object> params) {
        super(params);
        this.codes = (Map)params.get("codes");
    }

    @Override
    public CatalogEntity transform(CatalogEntityWorker worker, MarcField field) throws IOException {
        String data;
        Map m;
        Map subcodes = null;
        if (this.codes != null) {
            subcodes = (Map)this.codes.get("0");
        }
        if (subcodes != null && (m = (Map)this.codes.get((data = this.getValue(field)).substring(0, 1))) != null) {
            Resource resource = worker.getWorkerState().getResource().newResource(this.getClass().getSimpleName());
            for (int i = 1; i < data.length(); ++i) {
                Map q = (Map)m.get(Integer.toString(i));
                if (q == null) continue;
                String predicate = (String)q.get("_predicate");
                String code = data.substring(i, i + 1);
                if ("|".equals(code)) continue;
                String value = (String)q.get(code);
                if (value == null) {
                    logger.log(Level.WARNING, () -> MessageFormat.format("{0}: unspecified code {1} for {2}", worker.getWorkerState().getRecordIdentifier(), code, predicate));
                }
                resource.add(predicate, value);
            }
        }
        return super.transform(worker, field);
    }
}

