/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.catalog.entities.marc.hol;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xbib.catalog.entities.CatalogEntity;
import org.xbib.catalog.entities.CatalogEntityWorker;
import org.xbib.content.rdf.Resource;
import org.xbib.marc.MarcField;

public class GeneralInformation
extends CatalogEntity {
    private static final Logger logger = Logger.getLogger(GeneralInformation.class.getName());
    private final Map<String, Object> codes;

    public GeneralInformation(Map<String, Object> params) {
        super(params);
        this.codes = (Map)params.get("codes");
    }

    @Override
    public CatalogEntity transform(CatalogEntityWorker worker, MarcField field) throws IOException {
        String value = this.getValue(field);
        Resource info = worker.getWorkerState().getResource().newResource("GeneralInformation");
        this.examine(this.codes, info, value);
        return super.transform(worker, field);
    }

    private void examine(Map<String, Object> codes, Resource info, String value) throws IOException {
        for (Map.Entry<String, Object> entry : codes.entrySet()) {
            String v;
            int to;
            String key = entry.getKey();
            int pos = key.indexOf(45);
            String fromStr = pos > 0 ? key.substring(0, pos) : key;
            String toStr = pos > 0 ? key.substring(pos + 1) : key;
            int from = Integer.parseInt(fromStr);
            int n = to = fromStr.equals(toStr) ? from + 1 : Integer.parseInt(toStr) + 1;
            if (entry.getValue() instanceof String) {
                String pred = entry.getValue().toString();
                v = value.substring(from, to);
                if (pred.startsWith("date")) {
                    info.add(pred, this.checkDate(v));
                    continue;
                }
                if ("|".equals(v) || "||".equals(v) || "|||".equals(v) || "|| ".equals(v)) continue;
                info.add(pred, v);
                continue;
            }
            if (!(entry.getValue() instanceof Map)) continue;
            Map values = (Map)entry.getValue();
            String string = v = value.length() >= to ? value.substring(from, to) : "|";
            String predicate = (String)values.get("_predicate");
            if (predicate == null || "|".equals(v) || "||".equals(v) || "|||".equals(v) || "|| ".equals(v)) continue;
            if (values.containsKey(v)) {
                info.add(predicate, (String)values.get(v));
                continue;
            }
            logger.log(Level.WARNING, () -> MessageFormat.format("undefined general information code {0}, key {1}, in field {2}", v, predicate, value));
        }
    }

    private Integer checkDate(String date) {
        if ("    ".equals(date)) {
            return null;
        }
        try {
            int d = Integer.parseInt(date);
            if (d < 1450) {
                return null;
            }
            if (d == 9999) {
                return null;
            }
            return d;
        }
        catch (Exception e) {
            logger.log(Level.FINEST, e.getMessage(), e);
            return null;
        }
    }
}

