/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.catalog.entities.matching.string;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.xbib.catalog.entities.matching.string.UnterminatedQuotedStringException;

public class QuotedStringTokenizer
extends StringTokenizer
implements Iterator<String> {
    private String str;
    private String delim;
    private String quotes;
    private char escape;
    private boolean returnDelims;
    private int pos;
    private int len;
    private StringBuilder token;

    public QuotedStringTokenizer(String str) {
        this(str, " \t\n\r\f", "\"'", '\\', false);
    }

    public QuotedStringTokenizer(String str, String delim) {
        this(str, delim, "\"'", '\\', false);
    }

    public QuotedStringTokenizer(String str, String delim, String quotes, char escape, boolean returnDelims) {
        super(str, delim, returnDelims);
        this.str = str;
        this.len = str.length();
        this.delim = delim;
        this.quotes = quotes;
        this.pos = 0;
        for (int i = 0; i < quotes.length(); ++i) {
            if (delim.indexOf(quotes.charAt(i)) < 0) continue;
            throw new IllegalArgumentException("Invalid quote character '" + quotes.charAt(i) + "'");
        }
        this.escape = escape;
        if (delim.indexOf(escape) >= 0) {
            throw new IllegalArgumentException("Invalid escape character '" + escape + "'");
        }
        if (quotes.indexOf(escape) >= 0) {
            throw new IllegalArgumentException("Invalid escape character '" + escape + "'");
        }
        this.returnDelims = returnDelims;
    }

    private int skipDelim(int pos) {
        int p;
        for (p = pos; p < this.len && this.delim.indexOf(this.str.charAt(p)) >= 0; ++p) {
        }
        return p;
    }

    private int skipToken(int pos, boolean collect) {
        int p = pos;
        if (collect) {
            this.token = new StringBuilder();
        }
        boolean quoted = false;
        char quote = '\u0000';
        boolean escaped = false;
        while (p < this.len) {
            char curr = this.str.charAt(p);
            if (escaped) {
                escaped = false;
                if (collect) {
                    this.token.append(curr);
                }
            } else if (curr == this.escape) {
                escaped = true;
            } else if (quoted) {
                if (curr == quote) {
                    quoted = false;
                    quote = '\u0000';
                } else if (collect) {
                    this.token.append(curr);
                }
            } else if (this.quotes.indexOf(curr) >= 0) {
                quoted = true;
                quote = curr;
            } else {
                if (this.delim.indexOf(this.str.charAt(p)) >= 0) break;
                if (collect) {
                    this.token.append(curr);
                }
            }
            ++p;
        }
        if (escaped || quoted) {
            throw new UnterminatedQuotedStringException(this.str);
        }
        return p;
    }

    @Override
    public boolean hasMoreTokens() {
        if (!this.returnDelims) {
            this.pos = this.skipDelim(this.pos);
        }
        return this.pos < this.len;
    }

    @Override
    public String nextToken() {
        if (!this.returnDelims) {
            this.pos = this.skipDelim(this.pos);
        }
        if (this.pos >= this.len) {
            throw new NoSuchElementException();
        }
        if (this.returnDelims && this.delim.indexOf(this.str.charAt(this.pos)) >= 0) {
            return this.str.substring(this.pos, ++this.pos);
        }
        this.pos = this.skipToken(this.pos, true);
        return this.token.toString();
    }

    @Override
    public String nextToken(String delim) {
        this.delim = delim;
        return this.nextToken();
    }

    @Override
    public int countTokens() {
        int count = 0;
        int dcount = 0;
        int curr = this.pos;
        while (curr < this.len) {
            if (this.delim.indexOf(this.str.charAt(curr)) >= 0) {
                ++curr;
                ++dcount;
                continue;
            }
            curr = this.skipToken(curr, false);
            ++count;
        }
        if (this.returnDelims) {
            return count + dcount;
        }
        return count;
    }

    @Override
    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    @Override
    public Object nextElement() {
        return this.nextToken();
    }

    @Override
    public boolean hasNext() {
        return this.hasMoreTokens();
    }

    @Override
    public String next() {
        if (this.pos >= this.len) {
            throw new NoSuchElementException();
        }
        return this.nextToken();
    }

    @Override
    public void remove() {
    }
}

