/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.catalog.entities;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import org.xbib.catalog.entities.CatalogEntity;
import org.xbib.catalog.entities.CatalogEntityBuilder;
import org.xbib.catalog.entities.CatalogEntityWorkerState;
import org.xbib.catalog.entities.Classifier;
import org.xbib.catalog.entities.IdentifierMapper;
import org.xbib.catalog.entities.StatusCodeMapper;
import org.xbib.catalog.entities.Worker;
import org.xbib.content.rdf.Resource;
import org.xbib.content.resource.IRI;
import org.xbib.marc.MarcField;
import org.xbib.marc.MarcRecord;

public class CatalogEntityWorker
implements Worker<MarcRecord> {
    private static final Logger logger = Logger.getLogger(CatalogEntityWorker.class.getName());
    private static final IRI tempPredicate = IRI.create((String)"tmp");
    private final CatalogEntityBuilder entityBuilder;
    private final CRC32 crc32;
    private CatalogEntityWorkerState state;

    public CatalogEntityWorker(CatalogEntityBuilder entityBuilder) {
        this.entityBuilder = entityBuilder;
        this.crc32 = new CRC32();
    }

    private static Map.Entry<String, Object> subfieldDecoderMap(Map<String, Object> subfields, MarcField.Subfield field) {
        String k = null;
        String v = field.getValue();
        Object subfieldDef = subfields.get(field.getId());
        if (subfieldDef instanceof Map) {
            Map subfieldmap = (Map)subfieldDef;
            if (subfieldmap.containsKey(v.toString())) {
                Object o = subfieldmap.get(v.toString());
                if (o instanceof Map) {
                    Map.Entry me = ((Map)o).entrySet().iterator().next();
                    k = (String)me.getKey();
                    v = me.getValue();
                } else {
                    v = o;
                }
            }
        } else {
            k = (String)subfieldDef;
        }
        final String newKey = k;
        final String newValue = v;
        return new Map.Entry<String, Object>(){

            @Override
            public String getKey() {
                return newKey;
            }

            @Override
            public Object getValue() {
                return newValue;
            }

            @Override
            public Object setValue(Object value) {
                return null;
            }
        };
    }

    private CatalogEntityWorkerState newState() {
        return new CatalogEntityWorkerState(this.entityBuilder);
    }

    @Override
    public void execute(MarcRecord marcRecord) throws IOException {
        try {
            this.state = this.newState();
            this.build(marcRecord);
        }
        finally {
            this.entityBuilder.beforeFinishState(this.state);
            this.state.finish();
            this.entityBuilder.afterFinishState(this.state);
        }
    }

    public CatalogEntityWorkerState getWorkerState() {
        return this.state;
    }

    public Classifier classifier() {
        return this.entityBuilder.getClassifier();
    }

    public IdentifierMapper identifierMapper() {
        return this.entityBuilder.getIdentifierMapper();
    }

    public StatusCodeMapper statusCodeMapper() {
        return this.entityBuilder.getStatusMapper();
    }

    public void build(MarcRecord marcRecord) throws IOException {
        if (this.entityBuilder.isEnableChecksum()) {
            this.crc32.reset();
        }
        for (MarcField marcField : marcRecord.getFields()) {
            if (!marcField.isTagValid()) {
                this.entityBuilder.invalid(this.getWorkerState().getRecordIdentifier(), marcField, "field " + marcField + ": invalid tag");
                continue;
            }
            if (!marcField.isIndicatorValid()) {
                this.entityBuilder.invalid(this.getWorkerState().getRecordIdentifier(), marcField, "field " + marcField + " invalid indicator");
                continue;
            }
            CatalogEntity entity = this.entityBuilder.getEntitySpecification().retrieve(marcField);
            if (entity != null) {
                entity.transform(this, marcField);
                this.entityBuilder.mapped(this.getWorkerState().getRecordIdentifier(), marcField);
            } else {
                this.entityBuilder.unmapped(this.getWorkerState().getRecordIdentifier(), marcField, "field " + marcField + " tag definition missing in specification");
            }
            if (!logger.isLoggable(Level.FINE)) continue;
            logger.log(Level.FINE, "field=" + marcField + " entity=" + entity);
        }
        if (this.entityBuilder.isEnableChecksum()) {
            this.crc32.update(marcRecord.getFields().toString().getBytes(StandardCharsets.UTF_8));
            this.getWorkerState().getResource().add(IRI.builder().curie("crc").build(), Long.toHexString(this.crc32.getValue()));
            this.entityBuilder.checksum(this.crc32);
        }
        this.entityBuilder.getCounter().incrementAndGet();
    }

    /*
     * Unable to fully structure code
     */
    public Resource append(Resource resource, MarcField field, CatalogEntity entity) throws IOException {
        defaultSubfields = (Map)entity.getParams().get("subfields");
        if (defaultSubfields == null) {
            return resource;
        }
        fieldNames = new HashMap<MarcField, String>();
        newResource = resource.newResource(CatalogEntityWorker.tempPredicate);
        predicate = entity.getClass().getSimpleName();
        if (entity.getParams().containsKey("_predicate")) {
            predicate = (String)entity.getParams().get("_predicate");
        }
        if (field.isControl()) {
            subfields = (Map)entity.getParams().get("subfields");
            newResource.add((String)subfields.get(" "), field.getValue());
        } else {
            overridePredicate = false;
            for (MarcField.Subfield subfield : field.getSubfields()) {
                subfields = defaultSubfields;
                if (entity.getParams().containsKey("tags") && (o = entity.getParams().get("tags")) instanceof Map && (tags = (Map)o).containsKey(field.getTag())) {
                    if (!overridePredicate) {
                        predicate = (String)tags.get(field.getTag());
                    }
                    if ((subfields = (Map)entity.getParams().get(predicate)) == null) {
                        subfields = defaultSubfields;
                    }
                }
                if (entity.getParams().containsKey("indicators") && (indicators = (Map)entity.getParams().get("indicators")).containsKey(field.getTag()) && (indicatorMap = (Map)indicators.get(field.getTag())).containsKey(field.getIndicator())) {
                    if (!overridePredicate) {
                        predicate = (String)indicatorMap.get(field.getIndicator());
                        fieldNames.put(field, predicate);
                    }
                    if ((subfields = (Map)entity.getParams().get(predicate)) == null) {
                        subfields = defaultSubfields;
                    }
                }
                if ((me = CatalogEntityWorker.subfieldDecoderMap(subfields, subfield)).getKey() != null && me.getValue() != null) {
                    v = me.getValue().toString();
                    if (fieldNames.containsKey(field)) {
                        fieldName = (String)fieldNames.get(field);
                        vm = (Map)entity.getParams().get(fieldName);
                        if (vm == null) {
                            vm = (Map)entity.getParams().get("subfields");
                        }
                        v0 = vv = (pos = v.indexOf(32)) > 0 ? v.substring(0, pos) : v;
                        if (vm.containsKey(v)) {
                            newResource.add(me.getKey() + "Source", v);
                            v = (String)vm.get(v);
                        } else if (vm.containsKey(vv)) {
                            newResource.add(me.getKey() + "Source", v);
                            v = (String)vm.get(vv);
                        } else {
                            patterns = (List)entity.getParams().get(fieldName + "pattern");
                            if (patterns != null) {
                                for (Map pattern : patterns) {
                                    mme = pattern.entrySet().iterator().next();
                                    p = (String)mme.getKey();
                                    rel = (String)mme.getValue();
                                    m = Pattern.compile(p, 2).matcher(v);
                                    if (!m.matches()) continue;
                                    newResource.add(me.getKey() + "Source", v);
                                    v = rel;
                                    break;
                                }
                            }
                        }
                    } else {
                        fieldName = me.getKey();
                        if (entity.getParams().containsKey(fieldName)) {
                            try {
                                vm = (Map)entity.getParams().get(fieldName);
                                pos = v.indexOf(32);
                                v1 = vv = pos > 0 ? v.substring(0, pos) : v;
                                if (vm.containsKey(v)) {
                                    newResource.add(fieldName + "Source", v);
                                    v = (String)vm.get(v);
                                }
                                if (vm.containsKey(vv)) {
                                    newResource.add(fieldName + "Source", v);
                                    v = (String)vm.get(vv);
                                }
                                patterns = (List)entity.getParams().get(fieldName + "pattern");
                                if (patterns == null) ** GOTO lbl92
                                for (Map pattern : patterns) {
                                    mme = pattern.entrySet().iterator().next();
                                    p = (String)mme.getKey();
                                    rel = (String)mme.getValue();
                                    m = Pattern.compile(p, 2).matcher(v);
                                    if (!m.matches()) continue;
                                    newResource.add(fieldName + "Source", v);
                                    v = rel;
                                }
                            }
                            catch (ClassCastException e) {
                                CatalogEntityWorker.logger.log(Level.WARNING, MessageFormat.format("entity {0}: found {1} of class {2} in entity settings {3} for key {4} but must be a map", new Object[]{entity.getClass(), entity.getParams().get(fieldName), entity.getParams().get(fieldName).getClass(), entity.getParams(), fieldName}), e);
                            }
                        }
                    }
                    if (v != null) {
                        v = entity.transform(this, predicate, newResource, me.getKey(), v);
                    }
                    if (me.getKey().equals(predicate)) {
                        predicate = v;
                        overridePredicate = true;
                        continue;
                    }
                    newResource.add(me.getKey(), v);
                    continue;
                }
                subfieldId = subfield.getId();
                if (subfieldId.isEmpty()) {
                    subfieldId = " ";
                }
                if (subfields.containsKey(subfieldId)) {
                    property = (String)subfields.get(subfieldId);
                    newResource.add(property, entity.transform(this, predicate, newResource, property, subfield.getValue()));
                    continue;
                }
                this.entityBuilder.unmapped(this.getWorkerState().getRecordIdentifier(), field, "field " + field + " missing definition for subfield '" + subfieldId + "'");
            }
        }
        resource.rename(CatalogEntityWorker.tempPredicate, IRI.builder().curie(predicate).build());
        return newResource;
    }
}

