/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.catalog.entities;

import java.text.MessageFormat;
import java.time.LocalDate;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xbib.content.rdf.Resource;
import org.xbib.content.rdf.internal.DefaultAnonymousResource;
import org.xbib.content.resource.IRI;

public class EnumerationAndChronologyHelper {
    private static final Logger logger = Logger.getLogger(EnumerationAndChronologyHelper.class.getName());
    private static final Integer currentYear = LocalDate.now().getYear();
    private static final Pattern[] p1a = new Pattern[]{Pattern.compile("(\\d{4})(/?\\d{2,4})\\s*="), Pattern.compile("(\\d{4})(/?\\d{2,4})\\((\\d{4})(/?\\d{2,4})\\)"), Pattern.compile("(\\d{4})(/?\\d{2,4})"), Pattern.compile("(\\d{4})")};
    private static final Pattern[] p1b = new Pattern[]{Pattern.compile("(\\d+)\\.(\\d{4})(/\\d{0,4})"), Pattern.compile("(\\d+)\\.(\\d{4})"), Pattern.compile("(\\d+)\\.(\\[?\\d{2,4}\\]?\\d{2,4}/?\\d{0,4})")};
    private static final Pattern[] p1c = new Pattern[]{Pattern.compile("=\\s*\\[(\\d{4})(/?\\d{0,4})\\]"), Pattern.compile("\\.(\\d{4}/?\\d{0,4})\\s*=")};
    private static final Pattern[] p2a = new Pattern[]{Pattern.compile("(\\d{4}/?\\d{0,4}).*\\-\\s*$"), Pattern.compile("(\\d{4}).*\\-\\s*$"), Pattern.compile("(\\[\\d{2,4}\\]\\d{2,4}).*\\-\\s*$")};
    private static final Pattern[] p2b = new Pattern[]{Pattern.compile("(\\d+)\\.(\\d{4}/?\\d{0,4}).*?\\-\\s*$"), Pattern.compile("(\\d{0,4})\\.(\\d{4}).*?\\-\\s*$"), Pattern.compile("(.*?)\\.(\\d{4}/?\\d{0,4}).*\\-\\s*$")};
    private static final Pattern[] p2c = new Pattern[]{Pattern.compile("(\\d{4}/?\\d{0,4}),(.*?)\\s*\\-\\s*$")};
    private static final Pattern[] p3a = new Pattern[]{Pattern.compile("(\\d{4}/?\\d{0,4}).*\\-\\s*(\\d{4}/?\\d{0,4})"), Pattern.compile("(\\[\\d{2,4}\\]\\d{2,4}/?\\d{0,4}).*\\-\\s*(\\[\\d{2,4}\\]\\d{2,4}/?\\d{0,4})")};
    private static final Pattern[] p3b = new Pattern[]{Pattern.compile("(\\d+)\\.(\\d{4}/?\\d{0,4}).*\\-\\s*(\\d+)\\.(\\d{4}/?\\d{0,4})"), Pattern.compile("(.*?)\\.(\\d{4}/?\\d{0,4}).*\\-\\s*(.*?)\\.(\\d{4}/?\\d{0,4})"), Pattern.compile("(\\d+)\\.(\\[\\d{2,4}\\]\\d{2,4})(/\\d{0,4}).*\\-\\s*(\\d+)\\.(\\[\\d{2,4}\\]\\d{2,4})(/\\d{0,4})"), Pattern.compile("(\\d+)\\.(\\[\\d{2,4}\\]\\d{2,4}).*\\-\\s*(\\d+)\\.(\\[\\d{2,4}\\]\\d{2,4})")};
    private static final Pattern[] p3c = new Pattern[]{Pattern.compile("(\\d{4}),(.*?)\\s*\\-\\s*(\\d{4}),(.*?)")};
    private static final Pattern[] p3d = new Pattern[]{Pattern.compile("(\\d{4}),(.*?)\\s*\\-\\s*(\\d+)\\.(\\d{4})")};
    private static final Pattern[] p3e = new Pattern[]{Pattern.compile("(.*?)\\.(\\d{4})\\s*\\-\\s*(\\d{4}),(.*?)")};
    private static final Pattern[] g1a = new Pattern[]{Pattern.compile("(.*?)\\.(\\d{4}/?\\d{0,4})\\((\\d{4}/?\\d{0,4})\\)\\s*\\-\\s*(.*?)\\.(\\d{4}/?\\d{0,4})\\((\\d{4}/?\\d{0,4})\\)")};
    private static final Pattern[] g1b = new Pattern[]{Pattern.compile("(.*?)\\.(\\d{4}/?\\d{0,4})\\((\\d{4}/?\\d{0,4})\\)\\s*\\-\\s*(.*?)\\.(\\d{4}/?\\d{0,4})")};
    private static final Pattern[] g1c = new Pattern[]{Pattern.compile("(.*?)\\.(\\d{4}/?\\d{0,4})\\((\\d{4}/?\\d{0,4})\\)\\s*\\-")};
    private static final Pattern[] g1d = new Pattern[]{Pattern.compile("(.*?)\\.(\\d{4}/?\\d{0,4})\\((\\d{4}/?\\d{0,4})\\)")};
    private static final Pattern[] g1e = new Pattern[]{Pattern.compile("(\\d{4}/?\\d{0,4})\\((\\d{4}/?\\d{0,4})\\)")};
    private final Set<Integer> dates;
    private final List<Pattern> movingwalls;
    private final List<Integer> begin;
    private final List<Integer> end;
    private final List<String> beginVolume;
    private final List<String> endVolume;
    private final List<Integer> beginPubDate;
    private final List<Integer> endPubDate;
    private final List<Boolean> open;

    public EnumerationAndChronologyHelper(List<Pattern> movingwalls) {
        this.movingwalls = movingwalls;
        this.dates = new TreeSet<Integer>();
        this.begin = new LinkedList<Integer>();
        this.end = new LinkedList<Integer>();
        this.beginVolume = new LinkedList<String>();
        this.endVolume = new LinkedList<String>();
        this.beginPubDate = new LinkedList<Integer>();
        this.endPubDate = new LinkedList<Integer>();
        this.open = new LinkedList<Boolean>();
    }

    public List<Integer> getBegin() {
        return this.begin;
    }

    public List<Integer> getEnd() {
        return this.end;
    }

    public List<String> getBeginVolume() {
        return this.beginVolume;
    }

    public List<String> getEndVolume() {
        return this.endVolume;
    }

    public List<Integer> getBeginPubDate() {
        return this.beginPubDate;
    }

    public List<Integer> getEndPubDate() {
        return this.endPubDate;
    }

    public List<Boolean> getOpen() {
        return this.open;
    }

    public Resource parseToResource(String content) {
        return this.parseToResource(content, (Resource)new DefaultAnonymousResource());
    }

    public Resource parseToResource(String content, Resource resource) {
        int groups = this.parseInternal(content);
        for (int i = 0; i < groups; ++i) {
            resource.newResource("group").add("begindate", this.begin.get(i)).add("enddate", this.end.get(i)).add("beginvolume", this.beginVolume.get(i)).add("endvolume", this.endVolume.get(i)).add("beginpubdate", this.beginPubDate.get(i)).add("endpubdate", this.endPubDate.get(i)).add("open", this.open.get(i));
        }
        return resource;
    }

    private int parseInternal(String values) {
        if (values == null) {
            return 0;
        }
        int i = 0;
        block0: for (String value : values.split(";")) {
            Integer b;
            List<Integer> l;
            Integer b2;
            List<Integer> l2;
            List<Integer> l1;
            Integer e;
            Integer b3;
            Matcher m;
            boolean found = false;
            for (Pattern p : g1a) {
                m = p.matcher(value);
                found = m.find();
                if (!found) continue;
                this.begin.add(i, this.sanitizeDate(m.group(2)));
                this.end.add(i, this.sanitizeDate(m.group(5)));
                this.beginVolume.add(i, m.group(1));
                this.endVolume.add(i, m.group(4));
                this.beginPubDate.add(i, this.sanitizeDate(m.group(3)));
                this.endPubDate.add(i, this.sanitizeDate(m.group(6)));
                this.open.add(i, false);
                ++i;
            }
            if (found) continue;
            for (Pattern p : g1b) {
                m = p.matcher(value);
                found = m.find();
                if (!found) continue;
                this.begin.add(i, this.sanitizeDate(m.group(2)));
                this.end.add(i, this.sanitizeDate(m.group(5)));
                this.beginVolume.add(i, m.group(1));
                this.endVolume.add(i, m.group(4));
                this.beginPubDate.add(i, this.sanitizeDate(m.group(3)));
                this.endPubDate.add(i, this.sanitizeDate(m.group(5)));
                this.open.add(i, false);
                ++i;
            }
            if (found) continue;
            for (Pattern p : g1c) {
                m = p.matcher(value);
                found = m.find();
                if (!found) continue;
                this.begin.add(i, this.sanitizeDate(m.group(2)));
                this.end.add(i, null);
                this.beginVolume.add(i, m.group(1));
                this.endVolume.add(i, null);
                this.beginPubDate.add(i, this.sanitizeDate(m.group(3)));
                this.endPubDate.add(i, null);
                this.open.add(i, true);
                ++i;
            }
            if (found) continue;
            for (Pattern p : g1d) {
                m = p.matcher(value);
                found = m.find();
                if (!found) continue;
                this.begin.add(i, this.sanitizeDate(m.group(2)));
                this.end.add(i, null);
                this.beginVolume.add(i, m.group(1));
                this.endVolume.add(i, null);
                this.beginPubDate.add(i, this.sanitizeDate(m.group(3)));
                this.endPubDate.add(i, null);
                this.open.add(i, false);
                ++i;
            }
            if (found) continue;
            for (Pattern p : g1e) {
                m = p.matcher(value);
                found = m.find();
                if (!found) continue;
                this.begin.add(i, this.sanitizeDate(m.group(1)));
                this.end.add(i, null);
                this.beginVolume.add(i, null);
                this.endVolume.add(i, null);
                this.beginPubDate.add(i, this.sanitizeDate(m.group(2)));
                this.endPubDate.add(i, null);
                this.open.add(i, false);
                ++i;
            }
            if (found) continue;
            found = false;
            for (Pattern p : p3e) {
                m = p.matcher(value);
                found = m.find();
                if (!found) continue;
                b3 = this.sanitizeDate(m.group(2));
                e = this.sanitizeDate(m.group(3));
                this.begin.add(i, b3);
                this.end.add(i, e);
                this.beginVolume.add(i, m.group(1));
                this.endVolume.add(i, m.group(4));
                this.beginPubDate.add(i, b3);
                this.endPubDate.add(i, e);
                this.open.add(i, false);
                ++i;
                break;
            }
            if (found) continue;
            found = false;
            for (Pattern p : p3d) {
                m = p.matcher(value);
                found = m.find();
                if (!found) continue;
                b3 = this.sanitizeDate(m.group(1));
                e = this.sanitizeDate(m.group(4));
                this.begin.add(i, b3);
                this.end.add(i, e);
                this.beginVolume.add(i, m.group(2));
                this.endVolume.add(i, m.group(3));
                this.beginPubDate.add(i, b3);
                this.endPubDate.add(i, e);
                this.open.add(i, false);
                ++i;
                break;
            }
            if (found) continue;
            found = false;
            for (Pattern p : p3c) {
                m = p.matcher(value);
                found = m.find();
                if (!found) continue;
                b3 = this.sanitizeDate(m.group(1));
                e = this.sanitizeDate(m.group(3));
                this.begin.add(i, b3);
                this.end.add(i, e);
                this.beginVolume.add(i, m.group(2));
                this.endVolume.add(i, m.group(4));
                this.beginPubDate.add(i, b3);
                this.endPubDate.add(i, e);
                this.open.add(i, false);
                ++i;
                break;
            }
            if (found) continue;
            found = false;
            for (Pattern p : p3b) {
                m = p.matcher(value);
                found = m.find();
                if (!found) continue;
                b3 = this.sanitizeDate(m.group(2));
                e = this.sanitizeDate(m.group(4));
                this.begin.add(i, b3);
                this.end.add(i, e);
                this.beginVolume.add(i, m.group(1));
                this.endVolume.add(i, m.group(3));
                this.beginPubDate.add(i, b3);
                this.endPubDate.add(i, e);
                this.open.add(i, false);
                ++i;
                break;
            }
            if (found) continue;
            found = false;
            for (Pattern p : p3a) {
                Integer e2;
                m = p.matcher(value);
                found = m.find();
                if (!found) continue;
                if (m.groupCount() == 4) {
                    l1 = this.fractionDate(m.group(1) + m.group(2));
                    l2 = this.fractionDate(m.group(3) + m.group(4));
                    b2 = this.sanitizeDate(l1.get(0));
                    e2 = this.sanitizeDate(l2.get(l2.size() - 1));
                    this.begin.add(i, b2);
                    this.end.add(i, e2);
                    this.beginVolume.add(i, null);
                    this.endVolume.add(i, null);
                    this.beginPubDate.add(i, b2);
                    this.endPubDate.add(i, e2);
                    this.open.add(i, false);
                    ++i;
                    break;
                }
                l1 = this.fractionDate(m.group(1));
                l2 = this.fractionDate(m.group(2));
                b2 = this.sanitizeDate(l1.get(0));
                e2 = this.sanitizeDate(l2.get(l2.size() - 1));
                this.begin.add(i, b2);
                this.end.add(i, e2);
                this.beginVolume.add(i, null);
                this.endVolume.add(i, null);
                this.beginPubDate.add(i, b2);
                this.endPubDate.add(i, e2);
                this.open.add(i, false);
                ++i;
                break;
            }
            if (found) continue;
            found = false;
            for (Pattern p : p2c) {
                m = p.matcher(value);
                found = m.find();
                if (!found) continue;
                b3 = this.sanitizeDate(m.group(1));
                this.begin.add(i, b3);
                this.end.add(i, null);
                this.beginVolume.add(i, m.group(2));
                this.endVolume.add(i, null);
                this.beginPubDate.add(i, b3);
                this.endPubDate.add(i, null);
                this.open.add(i, true);
                ++i;
                break;
            }
            if (found) continue;
            found = false;
            for (Pattern p : p2b) {
                m = p.matcher(value);
                found = m.find();
                if (!found) continue;
                b3 = this.sanitizeDate(m.group(2));
                this.begin.add(i, b3);
                this.end.add(i, null);
                this.beginVolume.add(i, m.group(1));
                this.endVolume.add(i, null);
                this.beginPubDate.add(i, b3);
                this.endPubDate.add(i, null);
                this.open.add(i, true);
                ++i;
                break;
            }
            if (found) continue;
            found = false;
            for (Pattern p : p2a) {
                m = p.matcher(value);
                found = m.find();
                if (!found) continue;
                b3 = this.sanitizeDate(m.group(1));
                this.begin.add(i, b3);
                this.end.add(i, null);
                this.beginVolume.add(i, null);
                this.endVolume.add(i, null);
                this.beginPubDate.add(i, b3);
                this.endPubDate.add(i, null);
                this.open.add(i, true);
                ++i;
                break;
            }
            if (found) continue;
            found = false;
            for (Pattern p : p1c) {
                m = p.matcher(value);
                found = m.find();
                if (!found) continue;
                if (m.groupCount() > 1) {
                    l = this.fractionDate(m.group(1) + m.group(2));
                    b = this.sanitizeDate(l.get(0));
                    this.begin.add(i, b);
                    this.end.add(i, null);
                    this.beginVolume.add(i, null);
                    this.endVolume.add(i, null);
                    this.beginPubDate.add(i, b);
                    this.endPubDate.add(i, null);
                    this.open.add(i, false);
                    ++i;
                    if (l.size() <= 1) break;
                    b = this.sanitizeDate(l.get(1));
                    this.begin.add(i, b);
                    this.end.add(i, null);
                    this.beginVolume.add(i, null);
                    this.endVolume.add(i, null);
                    this.beginPubDate.add(i, b);
                    this.endPubDate.add(i, null);
                    this.open.add(i, false);
                    ++i;
                    break;
                }
                b3 = this.sanitizeDate(m.group(1));
                this.begin.add(i, b3);
                this.end.add(i, null);
                this.beginVolume.add(i, null);
                this.endVolume.add(i, null);
                this.beginPubDate.add(i, b3);
                this.endPubDate.add(i, null);
                this.open.add(i, false);
                ++i;
                break;
            }
            if (found) continue;
            found = false;
            for (Pattern p : p1b) {
                m = p.matcher(value);
                found = m.find();
                if (!found) continue;
                if (m.groupCount() == 3) {
                    l = this.fractionDate(m.group(2) + m.group(3));
                    b = this.sanitizeDate(l.get(0));
                    this.begin.add(i, b);
                    this.end.add(i, null);
                    this.beginVolume.add(i, m.group(1));
                    this.endVolume.add(i, null);
                    this.beginPubDate.add(i, b);
                    this.endPubDate.add(i, null);
                    this.open.add(i, false);
                    ++i;
                    if (l.size() <= 1) break;
                    b = this.sanitizeDate(l.get(1));
                    this.begin.add(i, b);
                    this.end.add(i, null);
                    this.beginVolume.add(i, m.group(1));
                    this.endVolume.add(i, null);
                    this.beginPubDate.add(i, b);
                    this.endPubDate.add(i, null);
                    this.open.add(i, false);
                    ++i;
                    break;
                }
                b3 = this.sanitizeDate(m.group(2));
                this.begin.add(i, b3);
                this.end.add(i, null);
                this.beginVolume.add(i, m.group(1));
                this.endVolume.add(i, null);
                this.beginPubDate.add(i, b3);
                this.endPubDate.add(i, null);
                this.open.add(i, false);
                ++i;
                break;
            }
            if (found) continue;
            found = false;
            for (Pattern p : p1a) {
                m = p.matcher(value);
                found = m.find();
                if (!found) continue;
                if (m.groupCount() == 4) {
                    l1 = this.fractionDate(m.group(1) + m.group(2));
                    l2 = this.fractionDate(m.group(3) + m.group(4));
                    b2 = this.sanitizeDate(l1.get(0));
                    this.begin.add(i, b2);
                    this.end.add(i, null);
                    this.beginVolume.add(i, null);
                    this.endVolume.add(i, null);
                    this.beginPubDate.add(i, b2);
                    this.endPubDate.add(i, null);
                    this.open.add(i, false);
                    ++i;
                    if (l1.size() > 1) {
                        b2 = this.sanitizeDate(l1.get(1));
                        this.begin.add(i, b2);
                        this.end.add(i, null);
                        this.beginVolume.add(i, null);
                        this.endVolume.add(i, null);
                        this.beginPubDate.add(i, b2);
                        this.endPubDate.add(i, null);
                        this.open.add(i, false);
                        ++i;
                    }
                    b2 = this.sanitizeDate(l2.get(0));
                    this.begin.add(i, b2);
                    this.end.add(i, null);
                    this.beginVolume.add(i, null);
                    this.endVolume.add(i, null);
                    this.beginPubDate.add(i, b2);
                    this.endPubDate.add(i, null);
                    this.open.add(i, false);
                    ++i;
                    if (l2.size() <= 1) break;
                    b2 = this.sanitizeDate(l2.get(1));
                    this.begin.add(i, b2);
                    this.end.add(i, null);
                    this.beginVolume.add(i, null);
                    this.endVolume.add(i, null);
                    this.beginPubDate.add(i, b2);
                    this.endPubDate.add(i, null);
                    this.open.add(i, false);
                    ++i;
                    break;
                }
                if (m.groupCount() == 2) {
                    l = this.fractionDate(m.group(1) + m.group(2));
                    b = this.sanitizeDate(l.get(0));
                    this.begin.add(i, b);
                    this.end.add(i, null);
                    this.beginVolume.add(i, null);
                    this.endVolume.add(i, null);
                    this.beginPubDate.add(i, b);
                    this.endPubDate.add(i, null);
                    this.open.add(i, false);
                    ++i;
                    if (l.size() <= 1) break;
                    b = this.sanitizeDate(l.get(1));
                    this.begin.add(i, b);
                    this.end.add(i, null);
                    this.beginVolume.add(i, null);
                    this.endVolume.add(i, null);
                    this.beginPubDate.add(i, b);
                    this.endPubDate.add(i, null);
                    this.open.add(i, false);
                    ++i;
                    break;
                }
                b3 = this.sanitizeDate(m.group(1));
                this.begin.add(i, b3);
                this.end.add(i, null);
                this.beginVolume.add(i, null);
                this.endVolume.add(i, null);
                this.beginPubDate.add(i, b3);
                this.endPubDate.add(i, null);
                this.open.add(i, false);
                ++i;
                break;
            }
            if (found || this.movingwalls == null) continue;
            for (Pattern p : this.movingwalls) {
                Matcher m2 = p.matcher(value);
                found = m2.find();
                if (!found) continue;
                Integer b4 = currentYear - Integer.parseInt(m2.group(1));
                this.begin.add(i, b4);
                this.end.add(i, null);
                this.beginVolume.add(i, null);
                this.endVolume.add(i, null);
                this.beginPubDate.add(i, b4);
                this.endPubDate.add(i, null);
                this.open.add(i, true);
                ++i;
                continue block0;
            }
        }
        return i;
    }

    private Integer sanitizeDate(String date) {
        int pos = date.indexOf(47);
        if (pos > 0) {
            if (pos > 4) {
                return null;
            }
            String s = date.substring(0, pos).replaceAll("[^\\d]", "");
            return this.sanitizeDate(Integer.parseInt(s));
        }
        String s = date.replaceAll("[^\\d]", "");
        return s.length() == 4 ? this.sanitizeDate(Integer.parseInt(s)) : null;
    }

    public Set<Integer> dates(Resource resource, String logmarker) {
        for (IRI iri : resource.predicates()) {
            resource.resources(iri).forEach(group -> {
                List<Integer> ends;
                List<Integer> starts;
                Iterator begindateCollection = group.objects("begindate").iterator();
                Object begindate = begindateCollection.hasNext() ? (Object)begindateCollection.next() : null;
                Iterator enddateCollection = group.objects("enddate").iterator();
                Object enddate = enddateCollection.hasNext() ? (Object)enddateCollection.next() : null;
                Iterator beginpubdateCollection = group.objects("beginpubdate").iterator();
                Object beginpubdate = beginpubdateCollection.hasNext() ? (Object)beginpubdateCollection.next() : null;
                Iterator endpubdateCollection = group.objects("endpubdate").iterator();
                Object endpubdate = endpubdateCollection.hasNext() ? (Object)endpubdateCollection.next() : null;
                Iterator openCollection = group.objects("open").iterator();
                Object open = openCollection.hasNext() ? (Object)openCollection.next() : null;
                int start = -1;
                if (begindate != null) {
                    starts = this.fractionDate(begindate.toString());
                    this.dates.addAll(starts);
                    start = starts.get(0);
                }
                if (beginpubdate != null) {
                    starts = this.fractionDate(beginpubdate.toString());
                    this.dates.addAll(starts);
                    start = starts.get(0);
                }
                int end = -1;
                if (enddate != null) {
                    ends = this.fractionDate(enddate.toString());
                    this.dates.addAll(ends);
                    end = ends.get(0);
                }
                if (endpubdate != null) {
                    ends = this.fractionDate(endpubdate.toString());
                    this.dates.addAll(ends);
                    end = ends.get(0);
                }
                if (open != null && "true^^xsd:boolean".equals(open.toString())) {
                    end = currentYear;
                }
                if (start >= 0 && end >= 0) {
                    if (start > currentYear || end > currentYear) {
                        logger.log(Level.WARNING, MessageFormat.format("future dates in {0}: {1},{2} (from {3},{4})", logmarker, start, end, begindate, enddate));
                    } else if (end - start > 250) {
                        logger.log(Level.WARNING, MessageFormat.format("too many years in {0}: {1}-{2} (from {3},{4})", logmarker, start, end, begindate, enddate));
                    } else if (start < 1500 || end < 1500) {
                        logger.log(Level.WARNING, MessageFormat.format("too early in {0}: {1},{2} ({3},{4})", logmarker, start, end, begindate, enddate));
                    } else {
                        for (int i = start; i <= end; ++i) {
                            this.dates.add(i);
                        }
                    }
                }
                if (this.dates.size() > 250) {
                    logger.log(Level.WARNING, MessageFormat.format("too many dates in {0}: {1}", logmarker, this.dates.size()));
                }
            });
        }
        return this.dates;
    }

    private Integer sanitizeDate(Integer date) {
        return date > 1500 && date <= currentYear ? date : null;
    }

    private List<Integer> fractionDate(String date) {
        LinkedList<Integer> dates = new LinkedList<Integer>();
        int pos = date.indexOf(47);
        if (pos > 0) {
            String s = date.substring(0, pos).replaceAll("[^\\d]", "");
            int base = Integer.parseInt(s);
            dates.add(base);
            int frac = 0;
            try {
                frac = Integer.parseInt(date.substring(pos + 1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (frac >= 100 && frac <= currentYear) {
                dates.add(frac);
            } else if (frac > 0 && frac < 100) {
                dates.add(frac += Integer.parseInt(s.substring(0, 2)) * 100);
            }
        } else {
            String s = date.replaceAll("[^\\d]", "");
            int base = Integer.parseInt(s);
            dates.add(base);
        }
        return dates;
    }
}

