/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.catalog.entities;

import java.io.Flushable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xbib.catalog.entities.Worker;

abstract class WorkerPool<R>
implements Flushable,
AutoCloseable {
    private static final int DEFAULT_WAIT_SECONDS = 30;
    private final BlockingQueue<R> queue;
    private final ExecutorService executorService;
    private final List<Worker<R>> workers;
    private final List<Worker<R>> activeWorkers;
    private final Lock lock = new ReentrantLock();
    private final int workerCount;
    private final int waitSeconds;
    private final AtomicBoolean closed;

    public WorkerPool() {
        this(Runtime.getRuntime().availableProcessors(), 30);
    }

    public WorkerPool(int workerCount) {
        this(workerCount, 30);
    }

    public WorkerPool(int workerCount, int waitSeconds) {
        this.workerCount = workerCount;
        this.waitSeconds = waitSeconds;
        this.queue = new SynchronousQueue<R>(true);
        this.executorService = Executors.newFixedThreadPool(workerCount);
        this.workers = new LinkedList<Worker<R>>();
        this.activeWorkers = new LinkedList<Worker<R>>();
        this.closed = new AtomicBoolean(true);
    }

    public WorkerPool<R> open() {
        if (this.closed.compareAndSet(true, false)) {
            for (int i = 0; i < this.workerCount; ++i) {
                Worker<R> worker = this.newWorker();
                this.workers.add(worker);
                Wrapper wrapper = new Wrapper(worker);
                this.executorService.submit(wrapper);
            }
        }
        return this;
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public BlockingQueue<R> getQueue() {
        return this.queue;
    }

    public abstract R getPoison();

    protected abstract Worker<R> newWorker();

    public void addActiveWorker(Worker<R> worker) {
        this.lock.lock();
        try {
            this.activeWorkers.add(worker);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void removeActiveWorker(Worker<R> worker) {
        this.lock.lock();
        try {
            this.activeWorkers.remove(worker);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void submit(R request) {
        if (this.closed.get()) {
            throw new UncheckedIOException(new IOException("closed"));
        }
        this.lock.lock();
        try {
            if (this.activeWorkers.isEmpty()) {
                throw new UncheckedIOException(new IOException("no worker available"));
            }
            if (request.equals(this.getPoison())) {
                throw new UncheckedIOException(new IOException("ignoring poison"));
            }
            this.queue.put(request);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UncheckedIOException(new IOException(e));
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.lock.lock();
            try {
                for (Worker<R> worker : this.activeWorkers) {
                    this.queue.put(this.getPoison());
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            finally {
                this.lock.unlock();
            }
            try {
                this.flush();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            try {
                this.executorService.shutdown();
                this.executorService.awaitTermination(this.waitSeconds, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new UncheckedIOException(new IOException(e));
            }
        }
    }

    private class Wrapper
    implements Runnable {
        private final Logger logger = Logger.getLogger(Worker.class.getName());
        private final Worker<R> worker;

        private Wrapper(Worker<R> worker) {
            this.worker = worker;
        }

        @Override
        public void run() {
            try {
                Object request;
                this.logger.log(Level.INFO, "start of worker " + this.worker);
                WorkerPool.this.addActiveWorker(this.worker);
                while (!(request = WorkerPool.this.getQueue().take()).equals(WorkerPool.this.getPoison())) {
                    this.logger.log(Level.INFO, "executing worker with request " + request.getClass());
                    this.worker.execute(request);
                    this.logger.log(Level.INFO, "worker executed with request " + request.getClass());
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.logger.log(Level.WARNING, e.getMessage(), e);
            }
            catch (Exception t) {
                this.logger.log(Level.SEVERE, t.getMessage(), t);
                throw new UncheckedIOException(new IOException(t));
            }
            finally {
                WorkerPool.this.removeActiveWorker(this.worker);
                this.logger.log(Level.INFO, "end of worker " + this.worker);
            }
        }
    }
}

