/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.catalog.entities.mab;

import java.io.IOException;
import java.util.Map;
import org.xbib.catalog.entities.CatalogEntity;
import org.xbib.catalog.entities.CatalogEntityWorker;
import org.xbib.marc.MarcField;

public class TypeMicroform
extends CatalogEntity {
    private final Map<String, Object> codes;
    private final Map<String, Object> facetcodes;
    private String facet = "dc.format";

    public TypeMicroform(Map<String, Object> params) {
        super(params);
        if (params.containsKey("_facet")) {
            this.facet = params.get("_facet").toString();
        }
        this.codes = this.getCodes();
        this.facetcodes = this.getFacetCodes();
    }

    @Override
    public CatalogEntity transform(CatalogEntityWorker worker, MarcField field) throws IOException {
        String code;
        Map q;
        int i;
        String value = this.getValue(field);
        if (this.codes == null) {
            throw new IllegalStateException("no codes section for " + field);
        }
        String predicate = (String)this.codes.get("_predicate");
        if (predicate == null) {
            predicate = this.getClass().getSimpleName();
        }
        for (i = 0; i < value.length(); ++i) {
            q = (Map)this.codes.get(Integer.toString(i));
            if (q == null) continue;
            code = (String)q.get(value.substring(i, i + 1));
            if (code == null && i + 1 < value.length()) {
                code = (String)q.get(value.substring(i, i + 2));
            }
            worker.getWorkerState().getResource().add(predicate, code);
        }
        if (this.facetcodes != null) {
            for (i = 0; i < value.length(); ++i) {
                q = (Map)this.facetcodes.get(Integer.toString(i));
                if (q == null) continue;
                code = (String)q.get(value.substring(i, i + 1));
                if (code == null && i + 1 < value.length()) {
                    code = (String)q.get(value.substring(i, i + 2));
                }
                if (code == null) continue;
                this.facetize(worker, code);
            }
        }
        return null;
    }

    @Override
    protected String getFacetName() {
        return this.facet;
    }
}

